% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_DVE.R
\name{do.dve}
\alias{do.dve}
\title{Distinguishing Variance Embedding}
\usage{
do.dve(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  preprocess = c("null", "center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Distinguishing Variance Embedding (DVE) is an unsupervised nonlinear manifold learning method.
It can be considered as a balancing method between Maximum Variance Unfolding and Laplacian
Eigenmaps. The algorithm unfolds the data by maximizing the global variance subject to the
locality-preserving constraint. Instead of defining certain kernel, it applies local scaling scheme
in that it automatically computes adaptive neighborhood-based kernel bandwidth.
}
\examples{
\donttest{
## generate swiss-roll dataset of size 200
X <- aux.gensamples(dname="crown",n=200)

## try different nbd size
out1 <- do.dve(X, type=c("proportion",0.4))
out2 <- do.dve(X, type=c("proportion",0.6))
out3 <- do.dve(X, type=c("proportion",0.8))

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="DVE::20\% connected")
plot(out2$Y, main="DVE::50\% connected")
plot(out3$Y, main="DVE::80\% connected")
par(opar)
}

}
\references{
\insertRef{wang_combining_2009}{Rdimtools}

\insertRef{qinggang_distinguishing_2010}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
