% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_nonlinear_TSNE.R
\name{do.tsne}
\alias{do.tsne}
\title{t-distributed Stochastic Neighbor Embedding}
\usage{
do.tsne(
  X,
  ndim = 2,
  perplexity = 30,
  eta = 0.05,
  maxiter = 2000,
  jitter = 0.3,
  jitterdecay = 0.99,
  momentum = 0.5,
  pca = TRUE,
  pcascale = FALSE,
  symmetric = FALSE,
  BHuse = TRUE,
  BHtheta = 0.25
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{perplexity}{desired level of perplexity; ranging [5,50].}

\item{eta}{learning parameter.}

\item{maxiter}{maximum number of iterations.}

\item{jitter}{level of white noise added at the beginning.}

\item{jitterdecay}{decay parameter in (0,1). The closer to 0, the faster artificial noise decays.}

\item{momentum}{level of acceleration in learning.}

\item{pca}{whether to use PCA as preliminary step; \code{TRUE} for using it, \code{FALSE} otherwise.}

\item{pcascale}{a logical; \code{FALSE} for using Covariance, \code{TRUE} for using Correlation matrix. See also \code{\link{do.pca}} for more details.}

\item{symmetric}{a logical; \code{FALSE} to solve it naively, and \code{TRUE} to adopt symmetrization scheme.}

\item{BHuse}{a logical; \code{TRUE} to use Barnes-Hut approximation. See \code{\link[Rtsne]{Rtsne}} for more details.}

\item{BHtheta}{speed-accuracy tradeoff. If set as 0.0, it reduces to exact t-SNE.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
\eqn{t}-distributed Stochastic Neighbor Embedding (t-SNE) is a variant of Stochastic Neighbor Embedding (SNE)
that mimicks patterns of probability distributinos over pairs of high-dimensional objects on low-dimesional
target embedding space by minimizing Kullback-Leibler divergence. While conventional SNE uses gaussian
distributions to measure similarity, t-SNE, as its name suggests, exploits a heavy-tailed Student t-distribution.
}
\examples{
\donttest{
## load iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## compare different perplexity
out1 <- do.tsne(X, ndim=2, perplexity=5)
out2 <- do.tsne(X, ndim=2, perplexity=10)
out3 <- do.tsne(X, ndim=2, perplexity=15)

## Visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=lab, main="tSNE::perplexity=5")
plot(out2$Y, pch=19, col=lab, main="tSNE::perplexity=10")
plot(out3$Y, pch=19, col=lab, main="tSNE::perplexity=15")
par(opar)
}

}
\references{
\insertRef{vandermaaten_visualizing_2008}{Rdimtools}
}
\seealso{
\code{\link{do.sne}}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
