/*
 * Decompiled with CFR 0.152.
 */
package org.math.r.drools.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ComparisonUtil {
    protected static final int EQ = 1;
    protected static final int NEQ = 2;
    protected static final int LT = 3;
    protected static final int LTE = 4;
    protected static final int GT = 5;
    protected static final int GTE = 6;
    protected static final String DATE_FORMAT = "yyyy-MM-dd";
    protected static final String TIME_FORMAT = "HH:mm:ss.SSS";
    protected static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    protected static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected static SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    protected static SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected static SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    protected static SimpleDateFormat[] backupFormats = new SimpleDateFormat[]{isoDateFormat, timestampFormat, dateFormat, timeFormat};

    protected static Object convert(String string, String type) {
        if (type == null || string == null) {
            return null;
        }
        try {
            if (type.equals(String.class.getName())) {
                return string;
            }
            if (type.equals(Character.class.getName())) {
                if (string.length() == 0) {
                    return null;
                }
                return Character.valueOf(string.charAt(0));
            }
            if (type.equals(BigDecimal.class.getName())) {
                return new BigDecimal(string);
            }
            if (type.equals(BigInteger.class.getName())) {
                return new BigInteger(string);
            }
            if (type.equals(Double.class.getName())) {
                return Double.valueOf(string);
            }
            if (type.equals(Float.class.getName())) {
                return Float.valueOf(string);
            }
            if (type.equals(Long.class.getName())) {
                return Long.valueOf(string);
            }
            if (type.equals(Integer.class.getName())) {
                return Integer.valueOf(string);
            }
            if (type.equals(Timestamp.class.getName()) || type.equals(Date.class.getName())) {
                Date date = ComparisonUtil.parseDate(timestampFormat, string, backupFormats);
                return new Timestamp(date.getTime());
            }
            if (type.equals(java.sql.Date.class.getName())) {
                Date date = ComparisonUtil.parseDate(dateFormat, string, backupFormats);
                return java.sql.Date.valueOf(new java.sql.Date(date.getTime()).toString());
            }
            if (type.equals(Time.class.getName())) {
                Date date = ComparisonUtil.parseDate(timeFormat, string, backupFormats);
                return Time.valueOf(new Time(date.getTime()).toString());
            }
            if (type.equals(Date.class.getName())) {
                return ComparisonUtil.parseDate(isoDateFormat, string, backupFormats);
            }
            if (type.equals(Boolean.class.getName())) {
                return Boolean.valueOf(string);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return string;
    }

    protected static Date parseDate(SimpleDateFormat format, String string, SimpleDateFormat[] backupFormats) {
        Date result = null;
        Exception ex = null;
        try {
            result = format.parse(string);
        }
        catch (Exception e) {
            ex = e;
        }
        if (result == null) {
            for (int index = 0; result == null && index < backupFormats.length; ++index) {
                try {
                    if (backupFormats[index] == format) continue;
                    result = backupFormats[index].parse(string);
                    continue;
                }
                catch (Exception e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
        }
        if (result == null) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static synchronized int compare(Object o1, Object o2, String typeName) {
        try {
            if (o1 instanceof String) {
                o1 = ComparisonUtil.convert((String)o1, typeName);
            }
            if (o2 instanceof String) {
                o2 = ComparisonUtil.convert((String)o2, typeName);
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
        catch (Exception e) {
            if (o1 != null && o1.equals(o2)) {
                return 0;
            }
            throw new RuntimeException("Incomparable objects");
        }
    }

    public static synchronized boolean eq(Object o1, Object o2, String typeName) {
        try {
            return ComparisonUtil.compare(ComparisonUtil.compare(o1, o2, typeName), 1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static synchronized boolean neq(Object o1, Object o2, String typeName) {
        try {
            return ComparisonUtil.compare(ComparisonUtil.compare(o1, o2, typeName), 2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static synchronized boolean lt(Object o1, Object o2, String typeName) {
        try {
            return ComparisonUtil.compare(ComparisonUtil.compare(o1, o2, typeName), 3);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static synchronized boolean lte(Object o1, Object o2, String typeName) {
        try {
            return ComparisonUtil.compare(ComparisonUtil.compare(o1, o2, typeName), 4);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static synchronized boolean gt(Object o1, Object o2, String typeName) {
        try {
            return ComparisonUtil.compare(ComparisonUtil.compare(o1, o2, typeName), 5);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static synchronized boolean gte(Object o1, Object o2, String typeName) {
        try {
            return ComparisonUtil.compare(ComparisonUtil.compare(o1, o2, typeName), 6);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static synchronized boolean compare(int result, int type) {
        return result == 0 && (type == 1 || type == 4 || type == 6) || result < 0 && (type == 3 || type == 3 || type == 2) || result > 0 && (type == 5 || type == 6 || type == 2);
    }
}

