% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BibEntryListExtract.R
\name{[[.BibEntry}
\alias{[[.BibEntry}
\title{Extract entries from a BibEntry object by index}
\usage{
\method{[[}{BibEntry}(x, i, drop = FALSE)
}
\arguments{
\item{x}{a BibEntry object}

\item{i}{numeric indices of entries to exctract, or a character vector of keys corresponding to the entries to be
extracted.}

\item{drop}{logical, should attributes besides class be dropped from result?}
}
\value{
an object of class BibEntry.
}
\description{
Operator for extracting BibEntry objects by index.
}
\note{
This method is different than the usual operator \code{[[} for lists in that a vector of indices may be specified.

This method behaves differently than the \code{[} operator for BibEntry objects in that it does not expand
crossreferences when returning, so that a parent entry or xdata entry will be dropped if it is not also indexed
when indexing the child entry.

This method is not affected by the value of \code{BibOptions()$return.ind}.
}
\examples{
file.name <- system.file("Bib", "biblatexExamples.bib", package="RefManageR")
bib <- suppressMessages(ReadBib(file.name))
bib[[20:21]]
bib[c("hyman", "loh")]

## Note this is FALSE because [[ does not inherit from the dropped parent entry while [ does.
identical(bib[1], bib[[1]])
}
\seealso{
Other operators: \code{\link{$.BibEntry}},
  \code{\link{$<-.BibEntry}}, \code{\link{+.BibEntry}},
  \code{\link{[.BibEntry}}, \code{\link{[<-.BibEntry}},
  \code{\link{[[<-.BibEntry}}, \code{\link{c.BibEntry}}
}
\keyword{database}
\keyword{list}
\keyword{manip}

