% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmdCite.R
\name{Cite}
\alias{Cite}
\alias{PrintBibliography}
\alias{PrintBibliography}
\alias{TextCite}
\alias{AutoCite}
\alias{Citep}
\alias{Citet}
\alias{Citep}
\alias{AutoCite}
\alias{Citet}
\alias{TextCite}
\alias{NoCite}
\title{Cite a BibEntry object in text and print all citations}
\usage{
Cite(bib, ..., textual = FALSE, before = NULL, after = NULL,
  .opts = list())

PrintBibliography(bib, .opts = list())

Citep(bib, ..., before = NULL, after = NULL, .opts = list())

AutoCite(bib, ..., before = NULL, after = NULL, .opts = list())

Citet(bib, ..., before = NULL, after = NULL, .opts = list())

TextCite(bib, ..., before = NULL, after = NULL, .opts = list())

NoCite(bib, ..., .opts = list())
}
\arguments{
\item{bib}{a \code{BibEntry} or \code{bibentry} object}

\item{...}{passed to \code{\link{SearchBib}} for indexing into bib.  A character
vector of keys, for example.}

\item{textual}{logical; if TRUE, a \dQuote{textual} citation is produced, i.e.
what is produced by \\citet in \code{natbib} and \\textcite in \code{BibLaTeX};
otherwise, a parenthetical citation as \\citep and \\autocite.}

\item{before}{string; optional text to display before the citation.}

\item{after}{string; optional text to display after the citation.}

\item{.opts}{list; See the relevant section in \code{\link{BibOptions}} for a
description of all valid options for these functions.}
}
\value{
For the cite functions: a character string containing the citation

PrintBibliography: The formatted list of references.

NoCite: no return value; invoked for its side-effect.
}
\description{
The \code{Cite} functions allow for citing a \code{BibEntry} object in text.  The
\code{PrintBibliography} function allows for printing the bibliography of all
the cited entries.  The \code{NoCite} function adds references to the bibliography
without including a citation.  These functions are most useful when used in,
e.g., a RMarkdown or RHTML document.
}
\details{
See the package vignettes and execute the examples below.

If \code{bib.style = "alphabetic"} or \code{bib.style = "numeric"},
then sorting needs to be done at the start of the document prior to using a cite
function as sorting is not done by the Printbibliography function for those styles
(specifying \code{sorting} in \code{.opts} is ignored in this case).  If no sorting
is none, the references are listed in the order they were cited in for those
two styles.

If the \code{...} argument to NoCite is identical to \dQuote{*}, then all
references in \code{bib} are added to the bibliography without citations.
}
\examples{
file <- system.file("Bib", "biblatexExamples.bib", package = "RefManageR")
BibOptions(check.entries = FALSE)
bib <- ReadBib(file)
Citet(bib, 12)
Citep(bib, c("loh", "geer"), .opts = list(cite.style = "numeric"),
      before = "see e.g., ")
Citet(bib, "loh", .opts = list(cite.style = "numeric", super = TRUE))
AutoCite(bib, eprinttype = "arxiv", .opts = list(cite.style = "authoryear"))
AutoCite(bib, eprinttype = "arxiv", .opts = list(cite.style = "pandoc"))
Citep(bib, author = "kant")
## shorthand field in both entries gets used for numeric and alphabetic labels
TextCite(bib, author = "kant", .opts = list(cite.style = "alphabetic"))
TextCite(bib, author = "kant", .opts = list(cite.style = "numeric"))
TextCite(bib, author = "kant", .opts = list(cite.style = "alphabetic",
         style = "html"))
punct <- unlist(BibOptions("bibpunct"))
punct[3:4] <- c("(", ")")
TextCite(bib, 33, .opts = list(bibpunct = punct, cite.style = "alphabetic"))

BibOptions(restore.defaults = TRUE)
\dontrun{
library(knitr)
## See also TestNumeric.Rmd and TestAlphabetic.Rmd for more examples
old.dir <- setwd(tdir <- tempdir())
doc <- system.file("Rmd", "TestRmd.Rmd", package = "RefManageR")
file.show(doc)
tmpfile <- tempfile(fileext = ".html", tmpdir = tdir)
knit2html(doc, tmpfile)
browseURL(tmpfile)

doc <- system.file("Rhtml", "TestAuthorYear.Rhtml", package = "RefManageR")
file.show(doc)
tmpfile <- tempfile(fileext = ".html", tmpdir = tdir)
knit2html(doc, tmpfile)
browseURL(tmpfile)
setwd(old.dir)
unlink(tdir)
}
}
\seealso{
\code{\link{print.BibEntry}}, \code{\link{BibOptions}},
\code{\link[utils]{citeNatbib}}
}
\keyword{methods}
\keyword{print}
