% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_ident_test.R
\name{point_ident_test}
\alias{point_ident_test}
\title{Function performing the test of point identification on a validation sample.}
\usage{
point_ident_test(
  validation,
  Ldata = NULL,
  Rdata = NULL,
  out_var,
  nc_var,
  c_var = NULL,
  alpha = 0.05,
  constraint = NULL,
  nc_sign = NULL,
  c_sign = NULL,
  weights_validation = NULL,
  weights_x = NULL,
  weights_y = NULL,
  nbCores = 1,
  grid = 10,
  eps_default = 0.5,
  R2bound = NULL,
  unchanged = FALSE,
  ties = FALSE
)
}
\arguments{
\item{validation}{dataset containing the joint distribution (Y,Xnc,Xc) where Y is the outcome,  Xnc are the non commonly observed regressors,  Xc are potential common regressors.}

\item{Ldata}{dataset containing (Y,Xc) where Y is the outcome, Xc are potential common regressors. Default is NULL}

\item{Rdata}{dataset containing (Xnc,Xc) where Xnc are the non commonly observed regressors, Xc are potential common regressors. Default is NULL.}

\item{out_var}{label of the outcome variable Y.}

\item{nc_var}{label of the non commonly observed regressors Xnc.}

\item{c_var}{label of the commonly observed regressors Xc.}

\item{alpha}{the level of the confidence intervals. Default is 0.05.}

\item{constraint}{a vector indicating the different constraints in a vector of the size of X_c indicating the type of constraints, if any on f(X_c) : "concave", "concave", "nondecreasing", "nonincreasing", "nondecreasing_convex", "nondecreasing_concave",  "nonincreasing_convex", "nonincreasing_concave", or NULL for none. Default is NULL, no contraints at all.}

\item{nc_sign}{if sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{c_sign}{if sign restrictions on the commonly observed regressors: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{weights_validation}{the sampling weights for the full dataset (Y, Xnc,Xc). Default is NULL.}

\item{weights_x}{the sampling weights for the dataset (Xnc,Xc). Default is NULL.}

\item{weights_y}{the sampling weights for the dataset (Y,Xc). Default is NULL.}

\item{nbCores}{number of cores for the parallel computation. Default is 1.}

\item{grid}{the number of points for the grid search on epsilon. Default is 30. If NULL, then epsilon is taken fixed equal to eps_default.}

\item{eps_default}{If grid =NULL, then epsilon is taken equal to eps_default.}

\item{R2bound}{the lower bound on the R2 of the long regression if any. Default is NULL.}

\item{unchanged}{Boolean indicating if the categories based on Xc must be kept unchanged (TRUE). Otherwise (FALSE), a thresholding approach is taken imposing that each value appears more than 10 times in both datasets and 0.01 per cent is the pooled one. Default is FALSE.}

\item{ties}{Boolean indicating if there are ties in the dataset. Default is FALSE.}
}
\value{
a list containing, in order:
- S: the point estimation used the statistic for the test

- S_ci: the CI on the upper bound

- stat: the statistic of the test

- the critical value at level alpha

- the p_value of the test

- the fit with the OLS on this sample

- n the sample size

- epsilon, the choice of epsilon we made

- r2long the r2 on the  long regression

 -r2short the r2 on the short regression
}
\description{
Function performing the test of point identification on a validation sample.
}
\examples{

### Simulating joint distribution according to this DGP
n=200
Xnc = rnorm(n,0,1.5)
epsilon = rnorm(n,0,1)

## true value
beta0 =1
Y = Xnc*beta0 + epsilon
out_var = "Y"
nc_var = "Xnc"

# create the datasets
validation<- as.data.frame(cbind(Y,Xnc))
colnames(validation) <- c(out_var,nc_var)


############# Estimation #############
test = point_ident_test (validation, Ldata=NULL,Rdata=NULL,out_var,nc_var)


}
