/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.pptx4r.elements;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTGraphicalObjectFrameLocking;
import org.docx4j.dml.CTNoFillProperties;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.CTNonVisualGraphicFrameProperties;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.dml.CTTable;
import org.docx4j.dml.CTTableCell;
import org.docx4j.dml.CTTableCellProperties;
import org.docx4j.dml.CTTableCol;
import org.docx4j.dml.CTTableGrid;
import org.docx4j.dml.CTTableProperties;
import org.docx4j.dml.CTTableRow;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.GraphicData;
import org.lysis.rdata.RAtomicInterface;
import org.lysis.reporters.pptx4r.elements.Utils;
import org.lysis.reporters.pptx4r.tools.Format;
import org.lysis.reporters.tables.GroupColumn;
import org.lysis.reporters.tables.TableBase;
import org.lysis.reporters.tables.TableLayoutPPTX;
import org.pptx4j.pml.CTGraphicalObjectFrame;
import org.pptx4j.pml.CTGraphicalObjectFrameNonVisual;
import org.pptx4j.pml.ObjectFactory;

public class DataTable
extends TableBase {
    private TableLayoutPPTX rSpecFormats;

    public DataTable(TableLayoutPPTX tf) throws FileNotFoundException, IOException {
        this.rSpecFormats = tf;
    }

    private void addHeader(CTTable reviewtable) throws JAXBException {
        CTTableCell tc;
        CTTextBody p;
        CTTableRow workingRow;
        if (this.hasGroupColumns()) {
            workingRow = new CTTableRow();
            int i = 0;
            while (i < this.groupColsSpecifications.size()) {
                String groupColName = ((GroupColumn)this.groupColsSpecifications.get(i)).getValue();
                int colSpan = ((GroupColumn)this.groupColsSpecifications.get(i)).getColspan();
                p = this.getP(groupColName, this.rSpecFormats.getGroupedheaderPar(), this.rSpecFormats.getGroupedheaderText());
                tc = this.getCell(this.rSpecFormats.getGroupedheaderCell(), p, colSpan, 1);
                workingRow.getTc().add(tc);
                int cc = 1;
                while (cc < colSpan) {
                    p = this.getEmptyP(this.rSpecFormats.getGroupedheaderPar());
                    tc = this.getCell(this.rSpecFormats.getGroupedheaderCell(), p, 0, 1);
                    workingRow.getTc().add(tc);
                    ++cc;
                }
                ++i;
            }
            reviewtable.getTr().add(workingRow);
        }
        workingRow = new CTTableRow();
        for (String colName : this.columnLabels.keySet()) {
            p = this.getP((String)this.columnLabels.get(colName), this.rSpecFormats.getHeaderPar(), this.rSpecFormats.getHeaderText());
            tc = this.getCell(this.rSpecFormats.getHeaderCell(), p, 1, 1);
            workingRow.getTc().add(tc);
        }
        reviewtable.getTr().add(workingRow);
    }

    private void addContent(CTTable reviewtable) throws Exception {
        int i = 0;
        while (i < this.data.get(0).size()) {
            CTTableRow workingRow = new CTTableRow();
            int j = 0;
            while (j < this.data.size()) {
                RAtomicInterface robj = this.data.get(j);
                CTTableCell tc = null;
                CTTextBody temp = !this.fontColors.containsKey(this.data.names(j)) ? robj.getP(i, this.rSpecFormats) : robj.getP(i, this.rSpecFormats, ((String[])this.fontColors.get(this.data.names(j)))[i]);
                CTTableCellProperties tcpr = robj.getCellProperties(this.rSpecFormats);
                if (this.fillColors.containsKey(this.data.names(j))) {
                    tcpr = (CTTableCellProperties)XmlUtils.deepCopy((Object)tcpr);
                    tcpr.setSolidFill(Format.getCol(((String[])this.fillColors.get(this.data.names(j)))[i]));
                }
                tc = !this.mergeInstructions.containsKey(this.data.names(j)) ? this.getCell(tcpr, temp, 1, 1) : this.getCell(tcpr, temp, 1, ((int[])this.mergeInstructions.get(this.data.names(j)))[i]);
                workingRow.getTc().add(tc);
                ++j;
            }
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private CTTableCell getCell(CTTableCellProperties cellProp, CTTextBody p, int colspan, int rowspan) {
        CTTableCell tc = new CTTableCell();
        tc.setTxBody(p);
        if (colspan > 1) {
            tc.setGridSpan(Integer.valueOf(colspan));
        } else if (colspan < 1) {
            tc.setHMerge(Boolean.valueOf(true));
            CTTableCellProperties temp = new CTTableCellProperties();
            temp.setNoFill(new CTNoFillProperties());
            tc.setTcPr(temp);
            return tc;
        }
        if (rowspan > 1) {
            tc.setRowSpan(Integer.valueOf(rowspan));
        } else if (rowspan < 1) {
            tc.setVMerge(Boolean.valueOf(true));
        }
        if (colspan > 0) {
            tc.setTcPr(cellProp);
        }
        return tc;
    }

    private CTTextBody getP(String value, CTTextParagraphProperties formatPar, CTTextCharacterProperties formatText) throws JAXBException {
        CTTextBody p = new CTTextBody();
        CTTextBodyProperties pp = new CTTextBodyProperties();
        CTTextListStyle ls = new CTTextListStyle();
        p.setBodyPr(pp);
        p.setLstStyle(ls);
        CTRegularTextRun textRun = Utils.getRun(value);
        textRun.setRPr(formatText);
        CTTextParagraph textPar = new CTTextParagraph();
        List runs = textPar.getEGTextRun();
        runs.add(textRun);
        textPar.setPPr(formatPar);
        p.getP().add(textPar);
        return p;
    }

    private CTTextBody getEmptyP(CTTextParagraphProperties formatPar) throws JAXBException {
        CTTextBody p = new CTTextBody();
        CTTextBodyProperties pp = new CTTextBodyProperties();
        CTTextListStyle ls = new CTTextListStyle();
        p.setBodyPr(pp);
        p.setLstStyle(ls);
        CTTextParagraph textPar = new CTTextParagraph();
        textPar.setPPr(formatPar);
        textPar.setEndParaRPr(new CTTextCharacterProperties());
        p.getP().add(textPar);
        return p;
    }

    public CTTable getTbl(long width) throws Exception {
        CTTable newTable = new CTTable();
        CTTableProperties tablpro = new CTTableProperties();
        CTTableGrid tg = new CTTableGrid();
        int i = 0;
        while (i < this.data.size()) {
            List gc = tg.getGridCol();
            CTTableCol tc = new CTTableCol();
            tc.setW(width);
            gc.add(tc);
            ++i;
        }
        newTable.setTblPr(tablpro);
        newTable.setTblGrid(tg);
        if (this.data.size() > 0) {
            this.addHeader(newTable);
            this.addContent(newTable);
        }
        return newTable;
    }

    public CTGraphicalObjectFrame getShape(long idx, long shape_id, long width) throws Exception {
        org.docx4j.dml.ObjectFactory dmlFactory = new org.docx4j.dml.ObjectFactory();
        ObjectFactory pmlFactory = new ObjectFactory();
        CTGraphicalObjectFrame graphicFrame = pmlFactory.createCTGraphicalObjectFrame();
        CTGraphicalObjectFrameNonVisual nvGraphicFramePr = pmlFactory.createCTGraphicalObjectFrameNonVisual();
        CTNonVisualDrawingProps cNvPr = dmlFactory.createCTNonVisualDrawingProps();
        CTNonVisualGraphicFrameProperties cNvGraphicFramePr = dmlFactory.createCTNonVisualGraphicFrameProperties();
        CTGraphicalObjectFrameLocking graphicFrameLocks = new CTGraphicalObjectFrameLocking();
        CTTransform2D xfrm = dmlFactory.createCTTransform2D();
        Graphic graphic = dmlFactory.createGraphic();
        GraphicData graphicData = dmlFactory.createGraphicData();
        graphicFrame.setNvGraphicFramePr(nvGraphicFramePr);
        nvGraphicFramePr.setCNvPr(cNvPr);
        cNvPr.setName("nvGraphicFrame " + shape_id);
        cNvPr.setId(shape_id);
        nvGraphicFramePr.setCNvGraphicFramePr(cNvGraphicFramePr);
        cNvGraphicFramePr.setGraphicFrameLocks(graphicFrameLocks);
        graphicFrameLocks.setNoGrp(Boolean.valueOf(true));
        nvGraphicFramePr.setNvPr(pmlFactory.createNvPr());
        graphicFrame.setXfrm(xfrm);
        graphicFrame.setGraphic(graphic);
        graphic.setGraphicData(graphicData);
        graphicData.setUri("http://schemas.openxmlformats.org/drawingml/2006/table");
        CTTable ctTable = this.getTbl(new Double(width / (long)this.data.size()).longValue());
        JAXBElement tbl = dmlFactory.createTbl(ctTable);
        graphicData.getAny().add(tbl);
        return graphicFrame;
    }
}

