package org.lysis.reporters.lists;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map.Entry;

import org.docx4j.wml.Numbering.AbstractNum;


public class ListDefinition {
	
	private int current_level;
	private int listid;
	private LinkedHashMap<Integer, LevelDefinition> lvlDefinitions;
	
	public ListDefinition(int listid) {
		current_level = 0;
		lvlDefinitions = new LinkedHashMap<Integer, LevelDefinition>();
		this.listid = listid;
	}
	public void setAbstractNumID( int numid){
		this.listid = numid;
	}
	public boolean addLevel(double indent_left, double indent_hanging,
			String textalign, String format, String pattern){
		
		if( current_level > 8 ){
			return false;
		}
		
		LevelDefinition ld = new LevelDefinition(indent_left, indent_hanging,
				textalign, format, pattern, current_level);
		lvlDefinitions.put(current_level, ld);
		current_level++;
		return true;
	}
	
	
	
	public AbstractNum getDocxAbstractNum() throws Exception{
		DocxListNumberingDefinition lnd = new DocxListNumberingDefinition(listid);
		AbstractNum abstractNum = lnd.getDocxAbstractNum();
		
		Iterator<Entry<Integer, LevelDefinition>> partIterator = lvlDefinitions.entrySet().iterator();
		
		while (partIterator.hasNext()) {
			Entry<Integer, LevelDefinition> ent = partIterator.next();
			abstractNum.getLvl().add( ent.getValue().getLvl() );
		}
			
		return abstractNum;
	}

	public LevelDefinition getLevelDefintion(int level){
		return lvlDefinitions.get(level-1);
	}
	
	public String getCSS(int list_id) {
		Iterator<Entry<Integer, LevelDefinition>> partIterator = lvlDefinitions.entrySet().iterator();
		String styles = "";
		while (partIterator.hasNext()) {
			Entry<Integer, LevelDefinition> ent = partIterator.next();
			styles += ent.getValue().getHTMLCSS(list_id);
		}
		return styles;
	}
	
	public String getCounterResets(int list_id) {
		Iterator<Entry<Integer, LevelDefinition>> partIterator = lvlDefinitions.entrySet().iterator();
		String counters = "";
		while (partIterator.hasNext()) {
			Entry<Integer, LevelDefinition> ent = partIterator.next();
			counters += ent.getValue().getCounterName(list_id) + " ";
		}
		return counters;
	}
	
}
