package org.lysis.reporters.tables;

import java.util.LinkedHashMap;

import org.lysis.reporters.formats.BorderProperties;
import org.lysis.reporters.formats.CellProperties;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.text.Paragraph;
import org.lysis.reporters.tools.Debug;

public class MetaRows {
	private LinkedHashMap<Integer, FlexRow> flexrowsList;
	private int nrows;

	public MetaRows(){
		nrows = 0;
		flexrowsList = new LinkedHashMap<Integer, FlexRow>();

	}
	public void add(FlexRow fr) {
		flexrowsList.put(nrows, fr);
		nrows++;
	}
	
	public LinkedHashMap<Integer, FlexRow> get() {
		return flexrowsList;
	}
	
	public FlexRow get(int i) {
		return flexrowsList.get(i);
	}
	public void reset() {
		flexrowsList.clear();
		nrows=0;
	}
	
	private void add(int i, int j, String par, TextProperties tp, boolean newPar) throws Exception{

		if( nrows < 1) return;
		if( i > (nrows-1) ) return;
		if( !flexrowsList.containsKey(i) ) return;
		
		FlexRow fr = flexrowsList.get(i);

		int col_id = fr.getCellIDCellAt(j);
		if( Debug.debug ) System.err.println("col_id: " + col_id );

		if( col_id < 0 ) return;
		if( Debug.debug ) System.err.println("set at:" + i + " col_id:" + col_id );

		FlexCell fc = fr.getCell(col_id);
		if( newPar ) {
			Paragraph p = new Paragraph();
			p.addText(par, tp.getClone());
			fc.getParagraphsSection().addParagraph(p);
		} else {
			Paragraph p = fc.getParagraphsSection().getLast();
			p.addText(par, tp.getClone());
		}
	}
	
	public void add(int[] i, int[] j, String[] par, TextProperties tp, boolean newPar) throws Exception{

		if( nrows < 1) return;
		
		int li = i.length;
		int lj = j.length;
		
		for(int row = 0 ; row < li ; row++ ){
			for( int col = 0 ; col < lj ; col++ ){
				add(i[row], j[col], par[row * lj + col], tp, newPar ); 
			}
		}
	}
	
	private void add(int i, int j, Paragraph par, boolean newPar) throws Exception{
		if( nrows < 1) return;
		if( i > (nrows-1) ) return;
		if( !flexrowsList.containsKey(i) ) return;
		
		FlexRow fr = flexrowsList.get(i);

		int col_id = fr.getCellIDCellAt(j);
		if( Debug.debug ) System.err.println("col_id: " + col_id );

		if( col_id < 0 ) return;
		if( Debug.debug ) System.err.println("set at:" + i + " col_id:" + col_id );

		FlexCell fc = fr.getCell(col_id);
		if( newPar ) {
			fc.getParagraphsSection().addParagraph(par);
		} else {
			fc.getParagraphsSection().getLast().addParagraph(par);
		}

	}
	public void add(int[] i, int[] j, Paragraph par, boolean newPar) throws Exception{
		
		if( nrows < 1) return;
		
		int li = i.length;
		int lj = j.length;
		
		for(int row = 0 ; row < li ; row++ ){
			for( int col = 0 ; col < lj ; col++ ){
				add(i[row], j[col], par, newPar ); 
			}
		}
	}


	public void setBorderGrid(BorderProperties inner_v, BorderProperties inner_h, BorderProperties outer_v, BorderProperties outer_h){
		
		if( nrows < 1) return;
		
		FlexRow workingRow;
		FlexCell fc;
		int ncol;
		
		for( int i = 0 ; i < nrows ; i++ ){
			workingRow = flexrowsList.get(i);
			ncol = workingRow.size();
			if( ncol > 0 ){
				for( int j = 0 ; j < ncol ; j++ ){
					fc = workingRow.getCell(j);
					
					if( i == 0 ) fc.setBorderTop(outer_h);
					else fc.setBorderTop(inner_h);
					
					if( i == (nrows-1) ) fc.setBorderBottom(outer_h);
					else fc.setBorderBottom(inner_h);
					
					if( j == 0 ) fc.setBorderLeft(outer_v);
					else fc.setBorderLeft(inner_v);
					
					if( j == (ncol-1) ) fc.setBorderRight(outer_v);
					else fc.setBorderRight(inner_v);
				}
			}
		}
	}
	
	public int getColspan( int i, int j ){
		if( !flexrowsList.containsKey(i) ) return -1;
		FlexRow temp = flexrowsList.get( i );
		if( !temp.hasCell(j) ) return -2;
		return temp.getCell( j ).getColspan();
	}
	

	
	public void set(int[] i, int[] j, BorderProperties properties, String side ){
		
		if( nrows < 1) return;
		
		int li = i.length;
		int lj = j.length;
		
		for(int row = 0 ; row < li ; row++ ){
			for( int col = 0 ; col < lj ; col++ ){
				set(i[row], j[col], properties, side); 
			}
		}
	}

	public void set(int i, int j, BorderProperties properties, String side ){
		if( Debug.debug ) System.err.println("set BorderProperties i:" + i + " j:" + j );

		if( nrows < 1) return;
		if( i > (nrows-1) ) return;
		if( !flexrowsList.containsKey(i) ) return;
		
		FlexRow fr = flexrowsList.get(i);

		int col_id = fr.getCellIDCellAt(j);
		if( Debug.debug ) System.err.println("col_id: " + col_id );

		if( col_id < 0 ) return;
		if( Debug.debug ) System.err.println("set at:" + i + " col_id:" + col_id );

		FlexCell fc = fr.getCell(col_id);

		if( side.equals("top")){
			fc.setBorderTop(properties);
		} else if( side.equals("bottom")){
			fc.setBorderBottom(properties);
		} else if( side.equals("left")){
			fc.setBorderLeft(properties);
		} else if( side.equals("right")){
			fc.setBorderRight(properties);
		} 

		
		if( side.equals("top")){
			if( !flexrowsList.containsKey(i-1) ) return;
			FlexRow frprev = flexrowsList.get(i-1);
			if( !frprev.hasCellAt(j)) return;
			col_id = frprev.getCellIDCellAt(j);
			fc = frprev.getCell(col_id);
			fc.setBorderBottom(properties);
		} else if( side.equals("bottom")){
			if( !flexrowsList.containsKey(i+1) ) return;
			FlexRow frnext = flexrowsList.get(i+1);
			col_id = frnext.getCellIDCellAt(j);
			if( !frnext.hasCell(col_id)) return;
			fc = frnext.getCell(col_id);
			fc.setBorderTop(properties);
		} else if( side.equals("left")){
			if( !fr.hasCell(col_id-1)) return;
			fc = fr.getCell(col_id-1);
			fc.setBorderRight(properties);
		} else if( side.equals("right")){
			if( !fr.hasCell(col_id+1)) return;
			fc = fr.getCell(col_id+1);
			fc.setBorderLeft(properties);
		} 
		
	}
	
	public void set(int[] i, int[] j, CellProperties cp ){

		int li = i.length;
		int lj = j.length;
		
		for(int row = 0 ; row < li ; row++ ){
			
			for( int col = 0 ; col < lj ; col++ ){
				set(i[row], j[col], cp); 
			}
		}
	}
	public void setBackgroundColors(int[] i, int[] j, String[] colors ){

		int li = i.length;
		int lj = j.length;
		
		for(int row = 0 ; row < li ; row++ ){
			
			for( int col = 0 ; col < lj ; col++ ){
				setBackgroundColor(i[row], j[col], colors[row * lj + col]); 
			}
		}
	}
	
	public void setBackgroundColor(int i, int j, String color){

		if( nrows < 1) return;
		if( i > (nrows-1) ) return;
		if( !flexrowsList.containsKey(i) ) return;
		
		FlexRow fr = flexrowsList.get(i);

		int col_id = fr.getCellIDCellAt(j);
		if( Debug.debug ) System.err.println("col_id: " + col_id );

		if( col_id < 0 ) return;
		if( Debug.debug ) System.err.println("set at:" + i + " col_id:" + col_id );

		FlexCell fc = fr.getCell(col_id);
		fc.getCellProperties().setBackgroundColor(color);
	}
	
	public void set(int i, int j, CellProperties properties){

		if( nrows < 1) return;
		if( i > (nrows-1) ) return;
		if( !flexrowsList.containsKey(i) ) return;
		
		FlexRow fr = flexrowsList.get(i);

		int col_id = fr.getCellIDCellAt(j);
		if( Debug.debug ) System.err.println("col_id: " + col_id );

		if( col_id < 0 ) return;
		if( Debug.debug ) System.err.println("set at:" + i + " col_id:" + col_id );

		FlexCell fc = fr.getCell(col_id);

		fc.setCellProperties(properties.getClone());		
	}
	public void set(int[] i, int[] j, ParProperties pp ){
		int li = i.length;
		int lj = j.length;
		
		for(int row = 0 ; row < li ; row++ ){
			for( int col = 0 ; col < lj ; col++ ){
				set(i[row], j[col], pp); 
			}
		}
	}
	
	public void set(int i, int j, ParProperties properties){

		if( nrows < 1) return;
		if( i > (nrows-1) ) return;
		if( !flexrowsList.containsKey(i) ) return;
		
		FlexRow fr = flexrowsList.get(i);

		int col_id = fr.getCellIDCellAt(j);
		if( Debug.debug ) System.err.println("col_id: " + col_id );

		if( col_id < 0 ) return;
		if( Debug.debug ) System.err.println("set at:" + i + " col_id:" + col_id );

		FlexCell fc = fr.getCell(col_id);

		fc.setParProperties(properties.getClone());
	}
	
	public void set(int[] i, int[] j, TextProperties tp ){
		int li = i.length;
		int lj = j.length;
		
		for(int row = 0 ; row < li ; row++ ){
			for( int col = 0 ; col < lj ; col++ ){
				set(i[row], j[col], tp); 
			}
		}
	}
	
	public void set(int i, int j, TextProperties properties){

		if( nrows < 1) return;
		if( i > (nrows-1) ) return;
		if( !flexrowsList.containsKey(i) ) return;
		
		FlexRow fr = flexrowsList.get(i);

		int col_id = fr.getCellIDCellAt(j);
		if( Debug.debug ) System.err.println("col_id: " + col_id );

		if( col_id < 0 ) return;
		if( Debug.debug ) System.err.println("set at:" + i + " col_id:" + col_id );

		FlexCell fc = fr.getCell(col_id);

		fc.setTextProperties(properties.getClone());		
	}
	
	public int size(){
		return nrows;
	}
}
