/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTGraphicalObjectFrameLocking;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.CTNonVisualGraphicFrameProperties;
import org.docx4j.dml.CTTable;
import org.docx4j.dml.CTTableCol;
import org.docx4j.dml.CTTableGrid;
import org.docx4j.dml.CTTableProperties;
import org.docx4j.dml.CTTableRow;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.GraphicData;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.CTTblLayoutType;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.STTblLayoutType;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.lysis.reporters.formats.BorderProperties;
import org.lysis.reporters.formats.CellProperties;
import org.lysis.reporters.formats.ColorProperties;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.tables.FlexCell;
import org.lysis.reporters.tables.MetaRows;
import org.lysis.reporters.text.Paragraph;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.Debug;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.pml.CTGraphicalObjectFrame;
import org.pptx4j.pml.CTGraphicalObjectFrameNonVisual;
import org.pptx4j.pml.ObjectFactory;

public class FlexTable
extends DocComponent
implements HTML4R,
PPTX4R,
DOCX4R {
    private MetaRows headerFlexRowList;
    private MetaRows footerFlexRowList;
    private int nrow;
    private int ncol;
    private ParagraphSet[][] cellTextValue;
    private CellProperties[][] cellPropertiesIndex;
    protected LinkedHashMap<Integer, int[]> rowSpanInstructions;
    protected LinkedHashMap<Integer, int[]> colSpanInstructions;
    protected double[] widths;
    protected long table_width;

    public FlexTable(int n, int c, TextProperties tp, ParProperties pp, CellProperties cp) {
        this.cellTextValue = new ParagraphSet[n][c];
        this.widths = new double[c];
        cp.setTextDirection("lrtb");
        int j = 0;
        while (j < c) {
            this.widths[j] = -1.0;
            ++j;
        }
        this.cellPropertiesIndex = new CellProperties[n][c];
        int i = 0;
        while (i < n) {
            int j2 = 0;
            while (j2 < c) {
                Paragraph par = new Paragraph();
                try {
                    par.addText("", tp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.cellTextValue[i][j2] = new ParagraphSet(pp);
                this.cellTextValue[i][j2].addParagraph(par);
                this.cellPropertiesIndex[i][j2] = cp.getClone();
                ++j2;
            }
            ++i;
        }
        this.headerFlexRowList = new MetaRows();
        this.footerFlexRowList = new MetaRows();
        this.nrow = n;
        this.ncol = c;
        this.rowSpanInstructions = new LinkedHashMap();
        this.colSpanInstructions = new LinkedHashMap();
        this.table_width = -1L;
    }

    public MetaRows getHeader() {
        return this.headerFlexRowList;
    }

    public MetaRows getFooter() {
        return this.footerFlexRowList;
    }

    public void setWidths(double[] w) {
        this.widths = w;
    }

    public void setTableWidth(long w) {
        this.table_width = w;
    }

    public void setRowSpanInstructions(int colindex, int[] x) {
        this.rowSpanInstructions.put(colindex, x);
    }

    public void setColSpanInstructions(int rowindex, int[] x) {
        this.colSpanInstructions.put(rowindex, x);
    }

    public void addBodyText(int[] i, int[] j, String[] par, TextProperties tp, boolean newPar) throws IOException {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                Paragraph p;
                ParagraphSet value = this.cellTextValue[i[row]][j[col]];
                if (newPar) {
                    p = new Paragraph();
                    p.addText(par[row * lj + col], tp);
                    value.addParagraph(p);
                } else {
                    p = value.getLast();
                    p.addText(par[row * lj + col], tp);
                }
                ++col;
            }
            ++row;
        }
    }

    public void addBodyText(int[] i, int[] j, Paragraph par, boolean newPar) throws IOException {
        if (Debug.debug) {
            System.err.println("addBodyText Paragraph");
        }
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                ParagraphSet value = this.cellTextValue[i[row]][j[col]];
                if (newPar) {
                    value.addParagraph(par);
                } else {
                    Paragraph p = value.getLast();
                    p.addParagraph(par);
                }
                ++col;
            }
            ++row;
        }
    }

    public void setRowsColors(int[] i, int[] r, int[] g, int[] b, int[] a) {
        int li = i.length;
        int row = 0;
        while (row < li) {
            ColorProperties color_ = new ColorProperties(r[row], g[row], b[row], a[row]);
            int col = 0;
            while (col < this.ncol) {
                this.cellPropertiesIndex[i[row]][col].setBackgroundColor(color_);
                ++col;
            }
            ++row;
        }
    }

    public void setColumnsColors(int[] j, int[] r, int[] g, int[] b, int[] a) {
        int lj = j.length;
        int col = 0;
        while (col < lj) {
            ColorProperties color_ = new ColorProperties(r[col], g[col], b[col], a[col]);
            int row = 0;
            while (row < this.nrow) {
                this.cellPropertiesIndex[row][j[col]].setBackgroundColor(color_);
                ++row;
            }
            ++col;
        }
    }

    public void setOddEvenColor(int[] r, int[] g, int[] b, int[] a) {
        int col;
        ColorProperties odd_color = new ColorProperties(r[1], g[1], b[1], a[1]);
        ColorProperties even_color = new ColorProperties(r[0], g[0], b[0], a[0]);
        int row = 0;
        while (row < this.nrow) {
            col = 0;
            while (col < this.ncol) {
                this.cellPropertiesIndex[row][col].setBackgroundColor(even_color);
                ++col;
            }
            row += 2;
        }
        row = 1;
        while (row < this.nrow) {
            col = 0;
            while (col < this.ncol) {
                this.cellPropertiesIndex[row][col].setBackgroundColor(odd_color);
                ++col;
            }
            row += 2;
        }
    }

    public void setBodyBorders(BorderProperties inner_v, BorderProperties inner_h, BorderProperties outer_v, BorderProperties outer_h) {
        if (Debug.debug) {
            System.err.println("setBodyBorders");
        }
        int row = 0;
        while (row < this.nrow) {
            int col = 0;
            while (col < this.ncol) {
                this.cellPropertiesIndex[row][col].setBorderLeft(inner_v);
                this.cellPropertiesIndex[row][col].setBorderRight(inner_v);
                this.cellPropertiesIndex[row][col].setBorderTop(inner_h);
                this.cellPropertiesIndex[row][col].setBorderBottom(inner_h);
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.ncol) {
            this.cellPropertiesIndex[0][col].setBorderTop(outer_h);
            this.cellPropertiesIndex[this.nrow - 1][col].setBorderBottom(outer_h);
            ++col;
        }
        row = 0;
        while (row < this.nrow) {
            this.cellPropertiesIndex[row][0].setBorderLeft(outer_v);
            this.cellPropertiesIndex[row][this.ncol - 1].setBorderRight(outer_v);
            ++row;
        }
        col = 0;
        while (col < this.ncol) {
            if (this.rowSpanInstructions.containsKey(col) && this.rowSpanInstructions.get(col)[this.nrow - 1] < 1) {
                int line = -1;
                int row2 = this.nrow - 1;
                while (row2 >= 0) {
                    line = row2;
                    if (this.rowSpanInstructions.get(col)[row2] > 0) break;
                    --row2;
                }
                this.cellPropertiesIndex[line][col].setBorderBottom(outer_h);
            }
            ++col;
        }
    }

    public void setBodyBorderProperties(int[] i, int[] j, BorderProperties properties, String side) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                if (side.equals("top")) {
                    if (Debug.debug) {
                        System.err.println("setBodyBorderProperties side " + side + " at :" + i[row] + " ; " + j[col]);
                    }
                    this.cellPropertiesIndex[i[row]][j[col]].setBorderTop(properties);
                    if (i[row] > 0) {
                        this.cellPropertiesIndex[i[row] - 1][j[col]].setBorderBottom(properties);
                    } else if (this.headerSize() > 0) {
                        this.headerFlexRowList.set(this.headerSize() - 1, j[col], properties, "bottom");
                    }
                } else if (side.equals("right")) {
                    this.cellPropertiesIndex[i[row]][j[col]].setBorderRight(properties);
                    if (j[col] < this.ncol - 2) {
                        this.cellPropertiesIndex[i[row]][j[col] + 1].setBorderLeft(properties);
                    }
                } else if (side.equals("bottom")) {
                    this.cellPropertiesIndex[i[row]][j[col]].setBorderBottom(properties);
                    if (i[row] < this.nrow - 1) {
                        this.cellPropertiesIndex[i[row] + 1][j[col]].setBorderTop(properties);
                    } else if (this.footerSize() > 0) {
                        this.footerFlexRowList.set(0, j[col], properties, "top");
                    }
                } else if (side.equals("left")) {
                    this.cellPropertiesIndex[i[row]][j[col]].setBorderLeft(properties);
                    if (j[col] > 0) {
                        this.cellPropertiesIndex[i[row]][j[col] - 1].setBorderRight(properties);
                    }
                }
                ++col;
            }
            ++row;
        }
    }

    public void setBackgroundColors(int[] i, int[] j, int[] r, int[] g, int[] b, int[] a) {
        int li = i.length;
        int lj = j.length;
        int index = 0;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                index = row * lj + col;
                CellProperties newone = this.cellPropertiesIndex[i[row]][j[col]].getClone();
                ColorProperties color_ = new ColorProperties(r[index], g[index], b[index], a[index]);
                newone.setBackgroundColor(color_);
                this.cellPropertiesIndex[i[row]][j[col]] = newone;
                ++col;
            }
            ++row;
        }
    }

    public void setCellProperties(int[] i, int[] j, CellProperties cp) {
        int li = i.length;
        int lj = j.length;
        cp.setTextDirection("lrtb");
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.cellPropertiesIndex[i[row]][j[col]] = cp.getClone();
                ++col;
            }
            ++row;
        }
    }

    public void setParProperties(int[] i, int[] j, ParProperties pp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.cellTextValue[i[row]][j[col]].setParProperties(pp.getClone());
                ++col;
            }
            ++row;
        }
    }

    public void setTextProperties(int[] i, int[] j, TextProperties tp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.cellTextValue[i[row]][j[col]].setTextProperties(tp.getClone());
                ++col;
            }
            ++row;
        }
    }

    private int headerSize() {
        return this.headerFlexRowList.size();
    }

    private int footerSize() {
        return this.footerFlexRowList.size();
    }

    public String toString() {
        String out = "";
        int i = 0;
        while (i < this.nrow) {
            out = String.valueOf(out) + "\n";
            int j = 0;
            while (j < this.ncol) {
                out = String.valueOf(out) + "\t" + this.cellTextValue[i][j].toString();
                ++j;
            }
            ++i;
        }
        return out;
    }

    private String HeaderHTML() {
        String out = "";
        out = String.valueOf(out) + "<thead>";
        int i = 0;
        while (i < this.headerSize()) {
            out = String.valueOf(out) + this.headerFlexRowList.get(i).getHTML();
            ++i;
        }
        out = String.valueOf(out) + "</thead>";
        return out;
    }

    private String FooterHTML() {
        String out = "";
        out = String.valueOf(out) + "<tfoot>";
        int i = 0;
        while (i < this.footerSize()) {
            out = String.valueOf(out) + this.footerFlexRowList.get(i).getHTML();
            ++i;
        }
        out = String.valueOf(out) + "</tfoot>";
        return out;
    }

    private void sendMetaDocxReference() {
        int i;
        if (this.headerSize() > 0) {
            i = 0;
            while (i < this.headerSize()) {
                this.headerFlexRowList.get(i).setDOCXMLPackage(this.docx_mlp);
                this.headerFlexRowList.get(i).setOrderedNumID(this.ordered_num_id);
                this.headerFlexRowList.get(i).setUnorderedNumID(this.unordered_num_id);
                ++i;
            }
        }
        if (this.footerSize() > 0) {
            i = 0;
            while (i < this.footerSize()) {
                this.footerFlexRowList.get(i).setDOCXMLPackage(this.docx_mlp);
                this.footerFlexRowList.get(i).setOrderedNumID(this.ordered_num_id);
                this.footerFlexRowList.get(i).setUnorderedNumID(this.unordered_num_id);
                ++i;
            }
        }
    }

    private void sendMetaHTMLReference() {
        int i;
        if (this.headerSize() > 0) {
            i = 0;
            while (i < this.headerSize()) {
                this.headerFlexRowList.get(i).setHTMLReference(this.list_id, this.counters, this.numbDefinition);
                ++i;
            }
        }
        if (this.footerSize() > 0) {
            i = 0;
            while (i < this.footerSize()) {
                this.footerFlexRowList.get(i).setHTMLReference(this.list_id, this.counters, this.numbDefinition);
                ++i;
            }
        }
    }

    private void HeaderDOCX(Tbl reviewtable) throws Exception {
        if (this.headerSize() > 0) {
            int i = 0;
            while (i < this.headerSize()) {
                TrPr trpr;
                Tr workingRow = this.headerFlexRowList.get(i).getTr();
                if (workingRow.getTrPr() == null) {
                    trpr = new TrPr();
                    workingRow.setTrPr(trpr);
                } else {
                    trpr = workingRow.getTrPr();
                }
                List cnfStyleOrDivIdOrGridBefore = trpr.getCnfStyleOrDivIdOrGridBefore();
                cnfStyleOrDivIdOrGridBefore.add(Context.getWmlObjectFactory().createCTTrPrBaseTblHeader(Context.getWmlObjectFactory().createBooleanDefaultTrue()));
                reviewtable.getContent().add(workingRow);
                ++i;
            }
        }
    }

    private void FooterDOCX(Tbl reviewtable) throws Exception {
        if (this.footerSize() > 0) {
            int i = 0;
            while (i < this.footerSize()) {
                Tr workingRow = this.footerFlexRowList.get(i).getTr();
                reviewtable.getContent().add(workingRow);
                ++i;
            }
        }
    }

    private void HeaderPPTX(CTTable reviewtable) throws Exception {
        if (this.headerSize() < 1) {
            return;
        }
        int i = 0;
        while (i < this.headerSize()) {
            CTTableRow workingRow = this.headerFlexRowList.get(i).getCTTableRow(this.slidePart);
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private void FooterPPTX(CTTable reviewtable) throws Exception {
        if (this.footerSize() < 1) {
            return;
        }
        int i = 0;
        while (i < this.footerSize()) {
            CTTableRow workingRow = this.footerFlexRowList.get(i).getCTTableRow(this.slidePart);
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private void BodyDOCX(Tbl reviewtable) throws Exception {
        int i = 0;
        while (i < this.nrow) {
            Tr workingRow = new Tr();
            int j = 0;
            while (j < this.ncol) {
                FlexCell fc = new FlexCell(this.cellTextValue[i][j], this.cellPropertiesIndex[i][j]);
                fc.setDOCXReference(this.ndp, this.ordered_num_id, this.unordered_num_id);
                fc.setDOCXMLPackage(this.getDOCXMLPackage());
                fc.getParagraphsSection().getParProperties().setOrderedNumid(this.ordered_num_id);
                fc.getParagraphsSection().getParProperties().setUnorderedNumid(this.unordered_num_id);
                if (this.rowSpanInstructions.containsKey(j)) {
                    fc.setRowspan(this.rowSpanInstructions.get(j)[i]);
                }
                if (this.colSpanInstructions.containsKey(i)) {
                    fc.setColspan(this.colSpanInstructions.get(i)[j]);
                }
                if (!this.colSpanInstructions.containsKey(i)) {
                    workingRow.getContent().add(fc.getTc());
                } else if (this.colSpanInstructions.containsKey(i) && this.colSpanInstructions.get(i)[j] > 0) {
                    workingRow.getContent().add(fc.getTc());
                }
                ++j;
            }
            reviewtable.getContent().add(workingRow);
            ++i;
        }
    }

    private void BodyPPTX(CTTable reviewtable) throws Exception {
        int i = 0;
        while (i < this.nrow) {
            CTTableRow workingRow = new CTTableRow();
            int j = 0;
            while (j < this.ncol) {
                FlexCell fc = new FlexCell(this.cellTextValue[i][j], this.cellPropertiesIndex[i][j]);
                fc.setPPTXSlidePart(this.slidePart);
                if (this.rowSpanInstructions.containsKey(j)) {
                    fc.setRowspan(this.rowSpanInstructions.get(j)[i]);
                }
                if (this.colSpanInstructions.containsKey(i)) {
                    fc.setColspan(this.colSpanInstructions.get(i)[j]);
                }
                workingRow.getTc().add(fc.getCTTableCell());
                ++j;
            }
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private String BodyHTML() {
        String out = "";
        out = String.valueOf(out) + "<tbody>";
        int i = 0;
        while (i < this.nrow) {
            out = String.valueOf(out) + "<tr>";
            int j = 0;
            while (j < this.ncol) {
                FlexCell fc = new FlexCell(this.cellTextValue[i][j], this.cellPropertiesIndex[i][j]);
                fc.setHTMLReference(this.list_id, this.counters, this.numbDefinition);
                if (this.rowSpanInstructions.containsKey(j)) {
                    fc.setRowspan(this.rowSpanInstructions.get(j)[i]);
                }
                if (this.colSpanInstructions.containsKey(i)) {
                    fc.setColspan(this.colSpanInstructions.get(i)[j]);
                }
                out = String.valueOf(out) + fc.getHTML();
                ++j;
            }
            out = String.valueOf(out) + "</tr>";
            ++i;
        }
        out = String.valueOf(out) + "</tbody>";
        return out;
    }

    private CTTableGrid get_pptx_table_grid(long width) {
        CTTableGrid tg = new CTTableGrid();
        int i = 0;
        while (i < this.ncol) {
            List gc = tg.getGridCol();
            CTTableCol tc = new CTTableCol();
            if (this.widths[i] < 0.0) {
                tc.setW(width);
            } else {
                tc.setW((long)(this.widths[i] * 914400.0));
            }
            gc.add(tc);
            ++i;
        }
        return tg;
    }

    private CTTblLayoutType getCTTblLayoutType() {
        CTTblLayoutType layoutType = new CTTblLayoutType();
        if (this.widths[0] > 0.0) {
            layoutType.setType(STTblLayoutType.FIXED);
        } else {
            layoutType.setType(STTblLayoutType.AUTOFIT);
        }
        return layoutType;
    }

    private TblGrid get_docx_table_frid() {
        TblGrid tblGrid = new TblGrid();
        if (this.widths[0] > 0.0) {
            int i = 0;
            while (i < this.ncol) {
                TblGridCol gridCol = Context.getWmlObjectFactory().createTblGridCol();
                gridCol.setW(BigInteger.valueOf((long)(this.widths[i] * 1440.0)));
                tblGrid.getGridCol().add(gridCol);
                ++i;
            }
        }
        return tblGrid;
    }

    private CTTable build_and_get_pptx_table(long width) throws Exception {
        CTTable newTable = new CTTable();
        CTTableProperties tablpro = new CTTableProperties();
        newTable.setTblPr(tablpro);
        newTable.setTblGrid(this.get_pptx_table_grid(width));
        if (this.nrow > 0) {
            this.HeaderPPTX(newTable);
            this.BodyPPTX(newTable);
            this.FooterPPTX(newTable);
        }
        return newTable;
    }

    public CTGraphicalObjectFrame get_flextable_pptx() throws Exception {
        if (!this.validatePPTXComponent()) {
            throw new Exception("class FlexTable: elements need to be set...");
        }
        org.docx4j.dml.ObjectFactory dmlFactory = new org.docx4j.dml.ObjectFactory();
        ObjectFactory pmlFactory = new ObjectFactory();
        CTGraphicalObjectFrame graphicFrame = pmlFactory.createCTGraphicalObjectFrame();
        CTGraphicalObjectFrameNonVisual nvGraphicFramePr = pmlFactory.createCTGraphicalObjectFrameNonVisual();
        CTNonVisualDrawingProps cNvPr = dmlFactory.createCTNonVisualDrawingProps();
        CTNonVisualGraphicFrameProperties cNvGraphicFramePr = dmlFactory.createCTNonVisualGraphicFrameProperties();
        CTGraphicalObjectFrameLocking graphicFrameLocks = new CTGraphicalObjectFrameLocking();
        Graphic graphic = dmlFactory.createGraphic();
        GraphicData graphicData = dmlFactory.createGraphicData();
        graphicFrame.setNvGraphicFramePr(nvGraphicFramePr);
        nvGraphicFramePr.setCNvPr(cNvPr);
        cNvPr.setName("nvGraphicFrame " + this.shape_id);
        cNvPr.setId(this.shape_id);
        nvGraphicFramePr.setCNvGraphicFramePr(cNvGraphicFramePr);
        cNvGraphicFramePr.setGraphicFrameLocks(graphicFrameLocks);
        graphicFrameLocks.setNoGrp(Boolean.valueOf(true));
        nvGraphicFramePr.setNvPr(pmlFactory.createNvPr());
        graphicFrame.setXfrm(this.getXfrm());
        graphicFrame.setGraphic(graphic);
        graphic.setGraphicData(graphicData);
        graphicData.setUri("http://schemas.openxmlformats.org/drawingml/2006/table");
        CTTable ctTable = this.build_and_get_pptx_table(new Double(this.table_width / (long)this.ncol).longValue());
        JAXBElement tbl = dmlFactory.createTbl(ctTable);
        graphicData.getAny().add(tbl);
        return graphicFrame;
    }

    @Override
    public boolean validateDOCXComponent() {
        if (this.unique_id < 0L) {
            if (Debug.debug) {
                System.err.println("unique_id is missing");
            }
            return false;
        }
        if (this.docx_mlp == null) {
            if (Debug.debug) {
                System.err.println("docx_mlp is missing");
            }
            return false;
        }
        if (this.ordered_num_id < 0L) {
            if (Debug.debug) {
                System.err.println("ordered_num_id uninitialized");
            }
            return false;
        }
        return true;
    }

    public Tbl get_docx_elt() throws Exception {
        if (!this.validateDOCXComponent()) {
            throw new Exception("class FlexTable: elements need to be set...");
        }
        this.sendMetaDocxReference();
        Tbl newTable = new Tbl();
        this.HeaderDOCX(newTable);
        this.BodyDOCX(newTable);
        this.FooterDOCX(newTable);
        TblPr tblpr = new TblPr();
        Jc alignment = new Jc();
        String textalign = this.getParProperties().getTextalign();
        if (textalign.equals("left")) {
            alignment.setVal(JcEnumeration.LEFT);
        } else if (textalign.equals("center")) {
            alignment.setVal(JcEnumeration.CENTER);
        } else if (textalign.equals("right")) {
            alignment.setVal(JcEnumeration.RIGHT);
        } else if (textalign.equals("justify")) {
            alignment.setVal(JcEnumeration.BOTH);
        }
        tblpr.setJc(alignment);
        tblpr.setTblLayout(this.getCTTblLayoutType());
        newTable.setTblGrid(this.get_docx_table_frid());
        newTable.setTblPr(tblpr);
        return newTable;
    }

    @Override
    public String getHTML() {
        this.sendMetaHTMLReference();
        String pStart = "";
        String align = "left";
        String pStop = "";
        String tableCSS = " style=\"margin-left:0px;margin-right:auto;border-collapse:collapse;\"";
        try {
            LinkedHashMap<String, String> ppr = this.getParProperties().get_html_pp();
            pStart = "<p style=\"" + Format.getJSString(ppr) + "\">";
            align = this.getParProperties().getTextalign();
            if (align.equals("justify")) {
                align = "left";
            }
            tableCSS = align.equals("left") ? " style=\"margin-left:0px;margin-right:auto;border-collapse:collapse;\"" : (align.equals("center") ? " style=\"margin-left:auto;margin-right:auto;border-collapse:collapse;\"" : " style=\"margin-left:auto;margin-right:0px;border-collapse:collapse;\"");
            pStop = "</p>";
        }
        catch (Exception ppr) {
            // empty catch block
        }
        String out = String.valueOf(pStart) + "<table" + tableCSS + ">";
        if (this.widths[0] > 0.0) {
            int j = 0;
            while (j < this.ncol) {
                out = String.valueOf(out) + "<col width=\"" + (int)(72.2 * this.widths[j]) + "\">";
                ++j;
            }
        }
        out = String.valueOf(out) + this.HeaderHTML();
        out = String.valueOf(out) + this.BodyHTML();
        out = String.valueOf(out) + this.FooterHTML();
        out = String.valueOf(out) + "</table>" + pStop;
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

