% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addCodeBlock.docx.R
\name{addCodeBlock.docx}
\alias{addCodeBlock.docx}
\title{Add a code block into a docx object}
\usage{
\method{addCodeBlock}{docx}(doc, file, text, par.properties = parProperties(),
  text.properties = textProperties(color = "#A7947D"), bookmark, ...)
}
\arguments{
\item{doc}{Object of class \code{\link{docx}}}

\item{file}{file. Not used if text is provided.}

\item{text}{character vector. The text to parse. Not used if file is provided.}

\item{par.properties}{code block paragraph properties. An object of class \code{\link{parProperties}}}

\item{text.properties}{code block text properties. An object of class \code{\link{textProperties}}}

\item{bookmark}{a character value ; id of the Word bookmark to
replace by the script. optional. See \code{\link{bookmark}}.}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{docx}}.
}
\description{
Add a code block into a \code{\link{docx}} object.
}
\details{
You have to one of the following argument: file or text or rscript.
}
\examples{
\dontrun{
doc.filename = "addCodeBlock.docx"

# set default font size to 10
options( "ReporteRs-fontsize" = 10 )

doc = docx( )
doc = addCodeBlock( doc, text = "ls -a\\nwhich -a ls" )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{docx}}, \code{\link{addCodeBlock}}
}

