/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.run;

import java.math.BigInteger;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.RPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class FontSize
extends AbstractRunProperty {
    protected static Logger log = LoggerFactory.getLogger(FontSize.class);
    public static final String CSS_NAME = "font-size";
    public static final String FO_NAME = "font-size";
    public static final ThreadLocal<BigInteger> mediumHalfPts = new ThreadLocal<BigInteger>(){

        @Override
        protected BigInteger initialValue() {
            return BigInteger.valueOf(22L);
        }
    };

    public String getCssName() {
        return "font-size";
    }

    public FontSize(HpsMeasure val) {
        this.setObject(val);
    }

    public FontSize(CSSValue value) {
        int mediumHP = 22;
        if (mediumHalfPts.get() != null) {
            mediumHP = mediumHalfPts.get().intValue();
        }
        HpsMeasure hpsMeasure = Context.getWmlObjectFactory().createHpsMeasure();
        CSSPrimitiveValue cssPrimitiveValue = (CSSPrimitiveValue)value;
        if (cssPrimitiveValue.getPrimitiveType() == 21) {
            String adjective = cssPrimitiveValue.getStringValue();
            if (adjective.equals("medium")) {
                hpsMeasure.setVal(BigInteger.valueOf(mediumHP));
            } else if (adjective.equals("xx-small")) {
                hpsMeasure.setVal(BigInteger.valueOf(Math.round(0.6 * (double)mediumHP)));
            } else if (adjective.equals("x-small")) {
                hpsMeasure.setVal(BigInteger.valueOf(Math.round(0.75 * (double)mediumHP)));
            } else if (adjective.equals("small")) {
                hpsMeasure.setVal(BigInteger.valueOf(Math.round(0.89 * (double)mediumHP)));
            } else if (adjective.equals("large")) {
                hpsMeasure.setVal(BigInteger.valueOf(Math.round(1.2 * (double)mediumHP)));
            } else if (adjective.equals("x-large")) {
                hpsMeasure.setVal(BigInteger.valueOf(Math.round(1.5 * (double)mediumHP)));
            } else if (adjective.equals("xx-large")) {
                hpsMeasure.setVal(BigInteger.valueOf(Math.round(2 * mediumHP)));
            } else {
                log.warn("TODO Handle FontSize units properly: " + adjective);
                hpsMeasure.setVal(BigInteger.valueOf(mediumHP));
            }
            this.setObject(hpsMeasure);
        } else if (cssPrimitiveValue.getPrimitiveType() == 5) {
            float pxVal = cssPrimitiveValue.getFloatValue((short)5);
            int iVal = UnitsOfMeasurement.pxToTwip(pxVal) / 10;
            hpsMeasure.setVal(BigInteger.valueOf(iVal));
            this.setObject(hpsMeasure);
        } else if (cssPrimitiveValue.getPrimitiveType() != 9) {
            log.error("TODO FontSize Handle units: " + cssPrimitiveValue.getPrimitiveType());
            this.debug("font-size", value);
        } else {
            short ignored = 1;
            float fVal = cssPrimitiveValue.getFloatValue(ignored);
            int iVal = Math.round(fVal * 2.0f);
            hpsMeasure.setVal(BigInteger.valueOf(iVal));
            this.setObject(hpsMeasure);
        }
    }

    public String getCssProperty() {
        if ((HpsMeasure)this.getObject() != null) {
            float pts = ((HpsMeasure)this.getObject()).getVal().floatValue() / 2.0f;
            return FontSize.composeCss("font-size", pts + "pt");
        }
        return "";
    }

    public void setXslFO(Element foElement) {
        if ((HpsMeasure)this.getObject() != null) {
            float pts = ((HpsMeasure)this.getObject()).getVal().floatValue() / 2.0f;
            foElement.setAttribute("font-size", pts + "pt");
        }
    }

    public void set(RPr rPr) {
        rPr.setSz((HpsMeasure)this.getObject());
    }

    public void set(CTTextCharacterProperties rPr) {
    }
}

