% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{setdiffNamed}
\alias{setdiffNamed}
\title{Like \code{setdiff}, but takes into account names}
\usage{
setdiffNamed(l1, l2, missingFill)
}
\arguments{
\item{l1}{A named list or named vector}

\item{l2}{A named list or named vector (must be same class as \code{l1})}

\item{missingFill}{A value, such as \code{NULL} or \code{""} or \code{"missing"} that will
be given to the elements returned, that are in \code{l2}, but not in \code{l1}}
}
\value{
A vector or list of the elements in \code{l1} that are not in \code{l2}, and
optionally the elements of \code{l2} that are not in \code{l1}, with values set to
\code{missingFill}
}
\description{
This will identify the elements in \code{l1} that are not in \code{l2}. If
\code{missingFill} is provided, then elements that are in \code{l2}, but not in \code{l1}
will be returned, assigning \code{missingFill} to their values. This might be
\code{NULL} or \code{""}, i.e., some sort of empty value. This function will work on
named lists, named vectors and likely on other named classes.
}
\details{
There are 3 types of differences that might occur with named
elements: 1. a new named element, 2. an removed named element, and 3. a
modified named element. This function captures all of these. In the case of
unnamed elements, e.g., \code{setdiff}, the first two are not seen as differences,
if the values are not different.
}
