% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BackendRserve.R
\docType{data}
\name{BackendRserve}
\alias{BackendRserve}
\title{Creates Rserve backend for processing HTTP requests}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Creates BackendRserve object which can start \link{Application}
using Rserve backend.
}
\section{Construction}{

Constructor for \code{BackendRserve}.\preformatted{BackendRserve$new(...)
}
\itemize{
\item \strong{\code{...}} \cr
Not used at the moment
}
}

\section{Methods}{

\itemize{
\item \strong{\code{start}}\code{(app, http_port = 8080, ..., background = FALSE)} \cr
\link{Application}, \code{integer(1)}, \code{any}, \code{logical(1)} -> \code{NULL} \cr
Starts RestRserve application from current R session.
\itemize{
\item \code{http_port} - http port for application. Negative values (such as -1)
means not to expose plain http.
\item \code{...} - key-value pairs of the Rserve configuration. If contains
\code{"http.port"} then \code{http_port} will be silently replaced with its value.
\item \code{background} - whether to try to launch in background process on UNIX
systems. Ignored on windows.
}
\item \strong{\code{set_request}}\code{(request, path = "/", parameters_query = NULL, headers = NULL, body = NULL)} :: \code{function}\cr
\itemize{
\item \code{request} :: \link{Request}\cr
\item \code{path} :: \code{character(1)}\cr
Character with requested path. Always starts with \code{/}.
\item \code{parameters_query} :: \code{named character()}\cr
A named character vector with URL decoded query parameters.
\item \code{headers} :: \code{raw()} | \code{character(1)}\cr
Request HTTP headers.
\item \code{body} :: \code{raw()} | \code{character()}\cr
Request body. Can be \code{NULL}, raw vector or named character vector for the
URL encoded form (like a \code{parameters_query} parameter).
}
\item \strong{\code{convert_response}}\code{(response)}\cr
\link{Response} -> \code{list()}\cr
Convert \code{self} object to Rserve compatible structure.
\href{https://github.com/s-u/Rserve/blob/e6b2b6b10e92b6e201d34a05394b2186fda30696/src/http.c#L353-L372}{According to http.c in Rserve} # nolint
returned list should have the following structure:
\itemize{
\item \code{body}: can be a character vector of length one or a raw vector.
if the character vector is named "file" then the content of a file of
that name is the body.
If the character vector is named "tmpfile" then the content of a
temporary file of that name is the body.
\item \code{content-type}: must be a character vector of length one or NULL
(if present, else default is \code{"text/plain"}).
\item \code{headers}: must be a character vector - the elements will have CRLF
appended and neither \code{Content-type} nor \code{Content-length} may be used.
\item \code{status-code}: must be an integer if present (default is 200).
}
}
}

\keyword{datasets}
