% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContentHandlersFactory.R
\name{ContentHandlers}
\alias{ContentHandlers}
\alias{ContentHandlersFactory}
\title{Content handlers collection}
\description{
Controls how RestRserve encodes and decodes different content types.
Designed to work jointly with \link{EncodeDecodeMiddleware}
}
\seealso{
\link{Application} \link{EncodeDecodeMiddleware}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{handlers}}{Handlers storage environment.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ContentHandlersFactory$new()}}
\item \href{#method-set_encode}{\code{ContentHandlersFactory$set_encode()}}
\item \href{#method-get_encode}{\code{ContentHandlersFactory$get_encode()}}
\item \href{#method-set_decode}{\code{ContentHandlersFactory$set_decode()}}
\item \href{#method-get_decode}{\code{ContentHandlersFactory$get_decode()}}
\item \href{#method-list}{\code{ContentHandlersFactory$list()}}
\item \href{#method-reset}{\code{ContentHandlersFactory$reset()}}
\item \href{#method-clone}{\code{ContentHandlersFactory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates ContentHandlersFactory object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentHandlersFactory$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_encode"></a>}}
\if{latex}{\out{\hypertarget{method-set_encode}{}}}
\subsection{Method \code{set_encode()}}{
Set handler to encode body for the specific content type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentHandlersFactory$set_encode(content_type, FUN)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content_type}}{MIME type.}

\item{\code{FUN}}{Function to encode response body.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_encode"></a>}}
\if{latex}{\out{\hypertarget{method-get_encode}{}}}
\subsection{Method \code{get_encode()}}{
Get encoder function for the specific content type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentHandlersFactory$get_encode(content_type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content_type}}{MIME type.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_decode"></a>}}
\if{latex}{\out{\hypertarget{method-set_decode}{}}}
\subsection{Method \code{set_decode()}}{
Set handler to decode body for the specific content type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentHandlersFactory$set_decode(content_type, FUN)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content_type}}{MIME type.}

\item{\code{FUN}}{Function to decode request body.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_decode"></a>}}
\if{latex}{\out{\hypertarget{method-get_decode}{}}}
\subsection{Method \code{get_decode()}}{
Get decoder function for the specific content type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentHandlersFactory$get_decode(content_type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content_type}}{MIME type.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-list"></a>}}
\if{latex}{\out{\hypertarget{method-list}{}}}
\subsection{Method \code{list()}}{
Convert handlers to list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentHandlersFactory$list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of handlers.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Resets all the content handlers to RestRserve defaults.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentHandlersFactory$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentHandlersFactory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
