% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EncodeDecodeMiddleware.R
\name{EncodeDecodeMiddleware}
\alias{EncodeDecodeMiddleware}
\title{Creates EncodeDecodeMiddleware middleware object}
\description{
Controls how RestRserve encodes and decodes different content types.
\strong{This middleware is passed by default to the \link{Application} constructor}.
}
\seealso{
\link{Middleware} \link{Application} \link{ContentHandlers}
}
\section{Super class}{
\code{\link[RestRserve:Middleware]{RestRserve::Middleware}} -> \code{EncodeDecodeMiddleware}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ContentHandlers}}{Class which controls how RestRserve encodes and
decodes different content types. See \link{ContentHandlers} for documentation.
User can add new encoding and decoding methods for new content types
using \code{set_encode} and \code{set_decode} methods.\cr
In theory user can replace it with his own class
(see \code{RestRserve:::ContentHandlersFactory}). However we believe that in
the majority of the cases using \link{ContentHandlers} will be enough.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-EncodeDecodeMiddleware-new}{\code{EncodeDecodeMiddleware$new()}}
\item \href{#method-EncodeDecodeMiddleware-clone}{\code{EncodeDecodeMiddleware$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EncodeDecodeMiddleware-new"></a>}}
\if{latex}{\out{\hypertarget{method-EncodeDecodeMiddleware-new}{}}}
\subsection{Method \code{new()}}{
Creates EncodeDecodeMiddleware middleware object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EncodeDecodeMiddleware$new(id = "EncodeDecodeMiddleware")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Middleware id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EncodeDecodeMiddleware-clone"></a>}}
\if{latex}{\out{\hypertarget{method-EncodeDecodeMiddleware-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EncodeDecodeMiddleware$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
