% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTrace.R
\name{readTrace}
\alias{readTrace}
\title{Read trace}
\usage{
readTrace(
  paths,
  format = "simple",
  delim = "\\t",
  burnin = 0.1,
  check.names = FALSE,
  ...
)
}
\arguments{
\item{paths}{(vector of character strings; no default) File path(s) to trace
file.}

\item{format}{(single character string; default = simple) Indicates type of
MCMC trace, complex indicates cases where trace contains vectors of vectors/
matrices - mnStochasticVariable monitor will sometimes be of this type.}

\item{delim}{(single character string; default = "\\t") Delimiter of file.}

\item{burnin}{(single numeric value; default = 0.1) Fraction of generations
to  discard (if value provided is between 0 and 1) or number of generations
(if value provided is greater than 1).}

\item{check.names}{(logical; default = FALSE) Passed to utils::read.table();
indicates if utils::read.table() should check column names and replace
syntactically invalid characters.}

\item{...}{(various) Additional arguments passed to utils::read.table().}
}
\value{
List of dataframes (of length 1 if only 1 log file provided).
}
\description{
Reads in MCMC log files
}
\details{
Reads in one or multiple MCMC log files from the same analysis
and discards a user-specified burn-in, compatible with multiple monitor
types. If the trace contains vectors of vectors and the user does not specify
format = "complex", readTrace() will read in those columns as factors
rather than as numeric vectors.
}
\examples{
# read and process a single trace file

\donttest{
# download the example dataset to working directory
url_gtr <-
   "https://revbayes.github.io/tutorials/intro/data/primates_cytb_GTR.log"
dest_path_gtr <- "primates_cytb_GTR.log"
download.file(url_gtr, dest_path_gtr)

# to run on your own data, change this to the path to your data file
file_single <- dest_path_gtr

one_trace <- readTrace(paths = file_single)

# remove file
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_gtr)

# read and process multiple trace files, such as from multiple runs of
# the same analysis

# download the example dataset to working directory
url_1 <-
"https://revbayes.github.io/tutorials/intro/data/primates_cytb_GTR_run_1.log"
dest_path_1 <- "primates_cytb_GTR_run_1.log"
download.file(url_1, dest_path_1)

url_2 <-
"https://revbayes.github.io/tutorials/intro/data/primates_cytb_GTR_run_2.log"
dest_path_2 <- "primates_cytb_GTR_run_2.log"
download.file(url_2, dest_path_2)

# to run on your own data, change this to the path to your data file
file_1 <- dest_path_1
file_2 <- dest_path_2

# read in the multiple trace files
multi_trace <- readTrace(path = c(file_1, file_2), burnin = 0.0)

# remove files
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_1, dest_path_2)
}

}
