% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.studies.R
\name{run.studies}
\alias{run.studies}
\title{This function runs the case studies included in the package}
\usage{
run.studies(
  TS,
  study,
  TSextra = list(aaa = 1),
  With.p.value = FALSE,
  BasicComparison = TRUE,
  nsample = 500,
  alpha = 0.05,
  param_alt,
  maxProcessor,
  B = 1000
)
}
\arguments{
\item{TS}{routine to calculate test statistic(s) or p value(s).}

\item{study}{either the name of the study, or its number. If missing all the studies are run.}

\item{TSextra}{=list(aaa=1), list passed to TS.}

\item{With.p.value}{=FALSE does user supplied routine return p values?}

\item{BasicComparison}{=TRUE if true compares tests on one default value of parameter of the alternative distribution.}

\item{nsample}{= 500, desired sample size.}

\item{alpha}{=0.05  type I error}

\item{param_alt}{(list of) values of parameter under the alternative hypothesis. If missing included values are used.}

\item{maxProcessor}{number of cores to use for parallel programming}

\item{B}{= 1000 number of simulation runs}
}
\value{
A (list of ) matrices of p.values
}
\description{
This function runs the case studies included in the package
}
\examples{
# New test is a simple chi-square test: 
chitest=function(x, pnull, param, TSextra) {
    nbins=TSextra$nbins
    bins=quantile(x, (0:nbins)/nbins)
    O=hist(x, bins, plot=FALSE)$counts
    if(param[1]!=-99) { #with parameter estimation
        E=length(x)*diff(pnull(bins, param))
        chi=sum((O-E)^2/E)
        pval=1-pchisq(chi, nbins-1-length(param))
    }
    else {
      E=length(x)*diff(pnull(bins))
      chi=sum((O-E)^2/E)
      pval=1-pchisq(chi,nbins-1)
    }  
    out=ifelse(TSextra$statistic, chi, pval)
    names(out)="ChiSquare"
    out
}
TSextra=list(nbins=10, statistic=FALSE) # Use 10 bins, test routine returns p-value
run.studies(chitest, TSextra=TSextra, With.p.value=TRUE, maxProcessor=1, B=200)
}
