% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_HEART_df.R
\name{HEART_scores}
\alias{HEART_scores}
\title{HEART risk score function
HEART = History, ECG, Age, Risk factors, Troponin}
\usage{
HEART_scores(
  data,
  typical_symptoms.num = typical_symptoms.num,
  ecg.normal = ecg.normal,
  abn.repolarisation = abn.repolarisation,
  ecg.st.depression = ecg.st.depression,
  Age = Age,
  diabetes = diabetes,
  smoker = smoker,
  hypertension = hypertension,
  hyperlipidaemia = hyperlipidaemia,
  family.history = family.history,
  atherosclerotic.disease = atherosclerotic.disease,
  presentation_hstni = presentation_hstni,
  Gender = Gender,
  classify
)
}
\arguments{
\item{data}{A data frame with all the variables needed for calculation:
typical_symptoms.num, ecg.normal, abn.repolarisation, ecg.st.depression,Age,
diabetes, smoker, hypertension, hyperlipidaemia, family.history,
atherosclerotic.disease, presentation_hstni, Gender}

\item{typical_symptoms.num}{a numeric vector of the number of typical symptoms}

\item{ecg.normal}{a binary numeric vector,  1 = yes and 0 = no}

\item{abn.repolarisation}{a binary numeric vector,  1 = yes and 0 = no}

\item{ecg.st.depression}{a binary numeric vector, 1 = yes and 0 = no}

\item{Age}{a numeric vector of age values, in years}

\item{diabetes}{a binary numeric vector, 1 = yes and 0 = no}

\item{smoker}{a binary numeric vector, 1 = yes and 0 = no}

\item{hypertension}{a binary numeric vector, 1 = yes and 0 = no}

\item{hyperlipidaemia}{a binary numeric vector, 1 = yes and 0 = no}

\item{family.history}{a binary numeric vector, 1 = yes and 0 = no}

\item{atherosclerotic.disease}{a binary numeric vector, 1 = yes and 0 = no}

\item{presentation_hstni}{a continuous numeric vector of the troponin levels}

\item{Gender}{a binary character vector of sex values. Categories should include only 'male' or 'female'}

\item{classify}{a logical parameter to indicate classification of Scores "TRUE" or none "FALSE"}
}
\value{
a data frame with two extra columns including the HEART score calculations
and their classifications
}
\description{
This function allows you to calculate the HEART score row wise
in a data frame with the required variables. It would then retrieve a data
frame with two extra columns including the calculations and their classifications
}
\examples{

# Create a data frame or list with the necessary variables
# Set the number of rows
num_rows <- 100
# Create a larger dataset with 100 rows
cohort_xx <- data.frame(
  typical_symptoms.num = as.numeric(sample(0:6, num_rows, replace = TRUE)),
  ecg.normal = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  abn.repolarisation = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  ecg.st.depression = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  Age = as.numeric(sample(30:80, num_rows, replace = TRUE)),
  diabetes = sample(c(1, 0), num_rows, replace = TRUE),
  smoker = sample(c(1, 0), num_rows, replace = TRUE),
  hypertension = sample(c(1, 0), num_rows, replace = TRUE),
  hyperlipidaemia = sample(c(1, 0), num_rows, replace = TRUE),
  family.history = sample(c(1, 0), num_rows, replace = TRUE),
  atherosclerotic.disease = sample(c(1, 0), num_rows, replace = TRUE),
  presentation_hstni = as.numeric(sample(10:100, num_rows, replace = TRUE)),
  Gender = sample(c("male", "female"), num_rows, replace = TRUE)
)
# Call the function with the cohort_xx
result <- HEART_scores(data = cohort_xx, classify = TRUE)
# Print the results
summary(result$HEART_score)
summary(result$HEART_strat)

}
\keyword{Age}
\keyword{Gender}
\keyword{HEART}
\keyword{abn.repolarisation}
\keyword{atherosclerotic.disease}
\keyword{classify}
\keyword{diabetes}
\keyword{ecg.normal}
\keyword{ecg.st.depression}
\keyword{family.history}
\keyword{hyperlipidaemia}
\keyword{hypertension}
\keyword{presentation_hstni}
\keyword{smoker}
\keyword{typical_symptoms.num}
