% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizations.R
\name{logXform}
\alias{logXform}
\title{Logarithmic Transformation}
\usage{
logXform(sample)
}
\arguments{
\item{sample}{The input data (vector)}
}
\value{
The log-transformed data (vector)
}
\description{
This function imputes minimum values per the recommendations of Osborne (2002) and
subsequently transforms the data to a base-10 logarithmic scale.
}
\examples{
values <- rnorm(100)
x <- logXform(values)
}
\references{
Osborne, J. W. (2002). Notes on the use of data transformations. Practical Assessment, Research and Evaluation, 9(1), 42-50.

            Osborne, J. W. (2002). The Effects of Minimum Values on Data Transformations. Retrieved from https://files.eric.ed.gov/fulltext/ED463313.pdf
}
