% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizations.R
\name{squareXform}
\alias{squareXform}
\title{Square-root Transformation}
\usage{
squareXform(sample)
}
\arguments{
\item{sample}{The input data (vector)}
}
\value{
The square-transformed data (vector)
}
\description{
This function left anchors the minimum value to 0 per the recommendations of Osborne (2002)
and subsequently transforms the data by taking the square-root of each value.
}
\examples{
values <- rnorm(100)
x <- squareXform(values)
}
\references{
Osborne, J. W. (2002). Notes on the use of data transformations. Practical Assessment, Research and Evaluation, 9(1), 42-50.

            Osborne, J. W. (2002). The Effects of Minimum Values on Data Transformations. Retrieved from https://files.eric.ed.gov/fulltext/ED463313.pdf
}
