/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.command.ActiveMQDestination;

public class CompositeDestinationInterceptor
implements DestinationInterceptor {
    private final DestinationInterceptor[] interceptors;

    public CompositeDestinationInterceptor(DestinationInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public Destination intercept(Destination destination) {
        for (int i = 0; i < this.interceptors.length; ++i) {
            destination = this.interceptors[i].intercept(destination);
        }
        return destination;
    }

    public void remove(Destination destination) {
        for (int i = 0; i < this.interceptors.length; ++i) {
            this.interceptors[i].remove(destination);
        }
    }

    public void create(Broker broker, ConnectionContext context, ActiveMQDestination destination) throws Exception {
        for (int i = 0; i < this.interceptors.length; ++i) {
            this.interceptors[i].create(broker, context, destination);
        }
    }
}

