% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbal_oil_optim.R
\name{mbal_optim_oil}
\alias{mbal_optim_oil}
\title{Generic function for predicting unknown parameters of a material balance model}
\usage{
mbal_optim_oil(optim_lst, time_lst)
}
\arguments{
\item{optim_lst}{a list object of class 'optimization_oil'}

\item{time_lst}{a list object of class 'time/date'}
}
\value{
a list of class 'mbal_oil' with estimates for the unknown parameters of the material balance model according to the class of 'optim_lst' and 'time_lst' objects
}
\description{
Generate a list of class 'mbal_oil' with estimates for the unknown parameters of the material balance model according to the class of 'optim_lst' and 'time_lst' objects
}
\examples{
p_pvt <- c(3330, 3150, 3000, 2850, 2700, 2550, 2400)

Bo <- c(1.2511, 1.2353, 1.2222, 1.2122, 1.2022, 1.1922, 1.1822)

Rs <- c(510, 477, 450, 425, 401, 375, 352)

Bg <- c(0.00087, 0.00092, 0.00096, 0.00101, 0.00107, 0.00113, 0.00120)

cw <- 2e-6

Bwi <- 1.0

Bw <- Bwi * exp(cw * (p_pvt[1] - p_pvt))

Rv <- rep(0, length(p_pvt))

muo <- rep(0.5, length(p_pvt))

muw <- rep(0.25, length(p_pvt))

mug <- rep(0.02, length(p_pvt))

pvt_table <- data.frame(p = p_pvt, Bo = Bo, Rs = Rs, Rv = Rv, Bg = Bg,
                       Bw = Bw, muo = muo, mug = mug, muw = muw)

p <- c(3330, 3150, 3000, 2850, 2700, 2550, 2400)

We <- rep(0, length.out = length(p))

Np <- c(0, 3.295, 5.903, 8.852, 11.503, 14.513, 17.730) * 1e6

Rp <- c(0, 1050, 1060, 1160, 1235, 1265, 1300)

Wp <- rep(0, length.out = length(p))

Wi <- rep(0, length.out = length(p))

Gi <- rep(0, length.out = length(p))

wf <- c(1, 1, 1, 0, 1, 0, 1)

mbal_optim_oil_lst <- mbal_optim_param_oil(input_unit = "Field",
output_unit = "Field", unknown_param = "N_m", aquifer_model = NULL,
phi = 0.2, swi = 0.2, Np = Np,Rp = Rp, Wp = Wp, Gi = Gi, Wi = Wi,
We = We, pb = 3330, p = p, pvt = pvt_table, cf = 0, wf = wf,
sorg = 0.2, sorw = 0)

time_lst <- mbal_time(c(0, 365, 730, 1095, 1460, 1825, 2190), "day")

optim_results <- mbal_optim_oil(mbal_optim_oil_lst, time_lst)

dplyr::glimpse(optim_results)
}
\references{
\insertRef{Walsh2003}{Rmbal}

\insertRef{Walsh1994a}{Rmbal}

\insertRef{Walsh1994}{Rmbal}

\insertRef{Walsh1995}{Rmbal}
}
