% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-harmonized_data_evaluate.R
\name{harmonized_dossier_evaluate}
\alias{harmonized_dossier_evaluate}
\title{Generate an assessment report for a harmonized dossier}
\usage{
harmonized_dossier_evaluate(
  harmonized_dossier,
  dataschema = attributes(harmonized_dossier)$`Rmonize::DataSchema`,
  taxonomy = NULL,
  as_dataschema_mlstr = TRUE
)
}
\arguments{
\item{harmonized_dossier}{A list containing the harmonized dataset(s).}

\item{dataschema}{A DataSchema object.}

\item{taxonomy}{An optional data frame identifying a variable classification
schema.}

\item{as_dataschema_mlstr}{Whether the output DataSchema should be coerced
with specific format restrictions for compatibility with other
Maelstrom Research software. TRUE by default.}
}
\value{
A list of data frames containing assessment reports for each harmonized dataset.
}
\description{
Assesses the content and structure of a harmonized dossier and generates
reports of the results. This function can be used to evaluate data structure,
presence of specific fields, coherence across elements, and data dictionary
formats.
}
\details{
A harmonized dossier is a named list containing one or more data frames,
which are harmonized datasets. A harmonized dossier is generally the
product of applying processing to a dossier object The name of each
harmonized dataset (data frame) is taken from the reference input dataset.
A harmonized dossier also contains the DataSchema and
Data Processing Elements used in processing as attributes.

A DataSchema is the list of core variables to generate across datasets and
related metadata. A DataSchema object is a list of data frames with elements
named 'Variables' (required) and 'Categories' (if any). The 'Variables'
element must contain at least the \code{name} column, and the 'Categories'
element must contain at least the \code{variable} and \code{name} columns to be usable
in any function. In 'Variables' the \code{name} column must also have unique
entries, and in 'Categories' the combination of \code{variable} and \code{name} columns
must also be unique.

A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal//}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.

The object may be specifically formatted to be compatible with additional
\href{https://maelstrom-research.org/page/software}{Maelstrom Research software},
in particular \href{https://www.obiba.org/pages/products/opal/}{Opal environments}.
}
\examples{
{

#' # use Rmonize_DEMO provided by the package
library(dplyr)

glimpse(harmonized_dossier_evaluate(Rmonize_DEMO$harmonized_dossier))

}

}
