% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{existsCtryNlData}
\alias{existsCtryNlData}
\title{Check if VIIRS nightlight stats exist locally}
\usage{
existsCtryNlData(ctryCode = NULL, admLevel, nlTypes, configNames,
  multiTileStrategy = pkgOptions("multiTileStrategy"),
  multiTileMergeFun = pkgOptions("multiTileMergeFun"),
  removeGasFlares = pkgOptions("removeGasFlares"), nlPeriods, nlStats,
  gadmVersion = pkgOptions("gadmVersion"),
  gadmPolyType = pkgOptions("gadmPolyType"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{character The ISO3 code of the country}

\item{admLevel}{character string The country admin level of interest}

\item{nlTypes}{character The nlTypes}

\item{configNames}{character the types of raster being processed}

\item{multiTileStrategy}{character How to handle multiple tiles per nlPeriod}

\item{multiTileMergeFun}{character The function to use to merge tiles}

\item{removeGasFlares}{logical Whether to perform gas flare removal pre-processing}

\item{nlPeriods}{character The nlPeriods}

\item{nlStats}{character The nlStats to check for}

\item{gadmVersion}{The GADM version to use}

\item{gadmPolyType}{The format of polygons to download from GADM}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
TRUE/FALSE
}
\description{
Check if VIIRS nightlight data for the country exists in the country 
    nightlight data file. First checks if the country nightlight data
    file exists.
}
\examples{
Rnightlights:::existsCtryNlData(ctryCode = "KEN", admLevel = "KEN_adm0", 
    nlTypes = "VIIRS.M", configNames = "stable_lights", nlPeriods = "201401", nlStats = "sum")

}
