% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robincar-linear.R
\name{robincar_linear2}
\alias{robincar_linear2}
\title{Covariate adjustment using linear working model, with simplified interface.}
\usage{
robincar_linear2(
  df,
  treat_col,
  response_col,
  car_strata_cols = NULL,
  covariate_cols = NULL,
  car_scheme = "simple",
  adj_method = "ANOVA",
  contrast_h = NULL,
  contrast_dh = NULL
)
}
\arguments{
\item{df}{A data.frame with the required columns}

\item{treat_col}{Name of column in df with treatment variable}

\item{response_col}{Name of the column in df with response variable}

\item{car_strata_cols}{Names of columns in df with car_strata variables}

\item{covariate_cols}{Names of columns in df with covariate variables. **If you want to include the strata variables as covariates also, add them here.**}

\item{car_scheme}{Name of the type of covariate-adaptive randomization scheme. One of: "simple", "pocock-simon", "biased-coin", "permuted-block".}

\item{adj_method}{Name of linear adjustment method to use. One of: "ANOVA", "ANCOVA", "ANHECOVA".}

\item{contrast_h}{An optional function to specify a desired contrast}

\item{contrast_dh}{An optional jacobian function for the contrast (otherwise use numerical derivative)}
}
\value{
See value of \link[RobinCar:robincar_linear]{RobinCar::robincar_linear()}, this function is a wrapper.
}
\description{
Estimate treatment-group-specific response means and (optionally)
treatment group contrasts using a linear working model for continuous outcomes.
}
\details{
Note the difference between \link[RobinCar:robincar_linear]{RobinCar::robincar_linear()} and \link[RobinCar:robincar_linear2]{RobinCar::robincar_linear2()} with regards to their `covariate_cols` argument.
}
