% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robincar-logrank.R
\name{robincar_logrank}
\alias{robincar_logrank}
\title{Robust (potentially stratified) logrank adjustment}
\usage{
robincar_logrank(adj_method, ...)
}
\arguments{
\item{adj_method}{Adjustment method, one of "CL", "CSL"}

\item{...}{Additional arguments to `robincar_tte`}
}
\value{
A result object with the following attributes:

\item{result}{A list: "statistic" is the adjusted logrank test statistic which can be used to obtain p-values; "U" and "se" are the numerator and denominator of the test statistic, respectively.}
\item{settings}{The covariate adjustment settings used.}
\item{original_df}{The dataset supplied by the user.}
}
\description{
Perform a robust covariate-adjusted logrank test ("CL") that can be stratified ("CSL") if desired.
}
\examples{
library(magrittr)
library(dplyr)
library(forcats)
set.seed(0)
n=100
data.simu0=data_gen(n=n,
                    theta=0,
                    randomization="permuted_block",
                    p_trt=0.5,
                    case="case2") \%>\% mutate(strata1=sample(letters[1:3],n,replace=TRUE),
                                             strata2=sample(LETTERS[4:5],n,replace=TRUE))

out <- robincar_logrank(df=data.simu0,
                        treat_col="I1",
                        p_trt=0.5,
                        ref_arm=0,
                        response_col="t",
                        event_col="delta",
                        covariate_cols=c("model_z1", "model_z2"),
                        car_scheme="simple",
                        adj_method=c("CL"))

set.seed(0)
n=100
data.simu0=data_gen(n=n,
                    theta=0,
                    randomization="permuted_block",
                    p_trt=0.5,
                    case="case1")

data.simu <- data.simu0 \%>\%
  tidyr::pivot_longer(cols=starts_with("car_strata"),
                      names_prefix="car_strata",
                      names_to="strt") \%>\%
  filter(value==1) \%>\% select(-value) \%>\%
  mutate(strt=forcats::as_factor(strt)) \%>\%
  select(t,strt) \%>\%
  left_join(data.simu0, .)

out1 <- robincar_logrank(df=data.simu,
                         treat_col="I1",
                         p_trt=0.5,
                         ref_arm=0,
                         response_col="t",
                         event_col="delta",
                         car_strata_cols="strt",
                         covariate_cols=NULL,
                         car_scheme=c("permuted-block"),
                         adj_method=c("CSL")
)

}
