% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-simdata.R
\name{data_gen}
\alias{data_gen}
\title{Data generation function from JRSS-B paper}
\usage{
data_gen(
  n,
  theta,
  randomization,
  p_trt,
  case = c("case1", "case2", "case3", "case4", "case5")
)
}
\arguments{
\item{n}{total number of subjects to be generated}

\item{theta}{true treatment effect}

\item{randomization}{randomization method in c("SR","CABC","permuted_block","minimization","urn")}

\item{p_trt}{proportion of treatment arm}

\item{case}{simulation case in the paper}
}
\value{
A data frame with the following columns:

\item{t}{event time}
\item{delta}{event indicator}
\item{I1}{assignment to treatment group 1}
\item{I0}{assignment to treatment group 0}
\item{model_z1, model_z2}{covariates}
\item{car_strata1, ...}{strata variables}
}
\description{
Data generation function from JRSS-B paper
}
