% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/watchlist.R
\name{watchlist}
\alias{watchlist}
\title{Manage your RobinHood watchlist}
\usage{
watchlist(RH, action, watchlist = "", ticker = "")
}
\arguments{
\item{RH}{object class RobinHood}

\item{action}{(string) one of: get, add, delete}

\item{watchlist}{(string) name of watchlist to add, delete, or get instruments, null will return a list of watchlist}

\item{ticker}{(string) list of tickers to add or delete, null will add or delete watchlist}
}
\description{
Add and delete instruments from your RobinHood watchlist.
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

# Get a vector of your watchlist names
watchlist(RH, action = "get")

# Get a vectors of symbols on your watchlist
watchlist(RH, action = "get", watchlist = "Default")

# Add a symbol to your watchlist
watchlist(RH, action = "add", watchlist = "Default", ticker = "CAT")

# Delete a symbol from your watchlist
watchlist(RH, action = "delete", watchlist = "Default", ticker = "CAT")
}
}
