% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainRobustTuneCRidge.R
\name{tuneandtrainRobustTuneCRidge}
\alias{tuneandtrainRobustTuneCRidge}
\title{Tune and Train RobustTuneC Ridge}
\usage{
tuneandtrainRobustTuneCRidge(
  data,
  dataext,
  K = 5,
  maxit = 120000,
  nlambda = 100
)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{dataext}{A data frame containing the external validation data. The first column should be the response 
variable (factor), and the remaining columns should be the predictor variables.}

\item{K}{Number of folds to use in cross-validation. Default is 5.}

\item{maxit}{Maximum number of iterations. Default is 120000.}

\item{nlambda}{The number of lambda values to use for cross-validation. Default is 100.}
}
\value{
A list containing the best lambda value (`best_lambda`), the final trained model (`best_model`), 
  and the AUC of the final model (`final_auc`).
}
\description{
This function tunes and trains a Ridge classifier using the \code{glmnet} package with the "RobustTuneC" method.
The function evaluates a sequence of lambda (regularization) values using K-fold cross-validation (K specified by the user) 
on the training dataset and selects the best model based on Area Under the Curve (AUC).
}
\details{
The function first performs K-fold cross-validation on the training dataset to select the best lambda value based on AUC. 
Then, the model is further validated on an external dataset, and the lambda value that provides the best performance on 
the external dataset is chosen as the final model. The Ridge regression is fitted using the selected lambda value, and 
the final model's performance is evaluated using AUC on the external validation dataset.
}
\examples{
# Load sample data
data(sample_data_train)
data(sample_data_extern)

# Example usage
result <- tuneandtrainRobustTuneCRidge(sample_data_train, sample_data_extern, 
  K = 5, maxit = 120000, nlambda = 100)
result$best_lambda
result$best_model
result$final_auc
}
