% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{robyn_converge}
\alias{robyn_converge}
\title{Check Models Convergence}
\usage{
robyn_converge(
  OutputModels,
  n_cuts = 20,
  sd_qtref = 3,
  med_lowb = 2,
  nrmse_win = c(0, 0.998),
  ...
)
}
\arguments{
\item{OutputModels}{List. Output from \code{robyn_run()}.}

\item{n_cuts}{Integer. Default to 20 (5\% cuts each).}

\item{sd_qtref}{Integer. Reference quantile of the error convergence rule
for standard deviation (Criteria #1). Defaults to 3.}

\item{med_lowb}{Integer. Lower bound distance of the error convergence rule
for median. (Criteria #2). Default to 3.}

\item{nrmse_win}{Numeric vector. Lower and upper quantiles thresholds to
winsorize NRMSE. Set values within [0,1]; default: c(0, 0.998) which is 1/500.}

\item{...}{Additional parameters}
}
\value{
List. Plots and MOO convergence results.
}
\description{
\code{robyn_converge()} consumes \code{robyn_run()} outputs
and calculate convergence status and builds convergence plots.
Convergence is calculated by default using the following criteria
(having kept the default parameters: sd_qtref = 3 and med_lowb = 2):
\describe{
  \item{Criteria #1:}{Last quantile's standard deviation < first 3
  quantiles' mean standard deviation}
  \item{Criteria #2:}{Last quantile's absolute median < absolute first
  quantile's absolute median - 2 * first 3 quantiles' mean standard
  deviation}
}
Both mentioned criteria have to be satisfied to consider MOO convergence.
}
\examples{
\dontrun{
# Having OutputModels results
MOO <- robyn_converge(
  OutputModels,
  n_cuts = 10,
  sd_qtref = 3,
  med_lowb = 3
)
}
}
