% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ledger-lib.R
\docType{class}
\name{ScraperLedger.class}
\alias{ScraperLedger.class}
\title{ScraperLedger}
\format{\code{\link{R6Class}} object.}
\usage{
ScraperLedger.class
}
\description{
Ledger of scraping status of each objects. Allows different type of states:
queued, scraping, scraped, failed, exception, skipped
}
\details{
For flexible and reproducible configuration for package development
}
\section{Methods}{

\describe{
  \item{\code{initialize()}}{initializes the object}
  \item{\code{addFilename(source, filename)}}{add filename to the ledger}
  \item{\code{getIdFilename(source, filename)}}{Returns id/row of source and filenames parameters in the ledger}
  \item{\code{updateStatus(source, filename, status, status.field = 'status', scraped.polyhedron = NA, obs ='')}}{Updates status of source and filenames parameters in Ledger }
  \item{\code{savePreloadedData()}}{Internal method which saves a file with an estimation of time required time to scrape each filename}
  \item{\code{loadPreloadedData()}}{Load a file with an estimation of time required time to scrape each filename}
  \item{\code{getSizeToTimeScrape(sources, time2scrape = 60)}}{Estimates how much filenames could be scraped in a time frame, considering data retrieved with loadPreloadedData}
  \item{\code{resetStatesMetrics()}}{Reset metrics of application of different status values}
  \item{\code{countStatusUse(status.field,status)}}{Add an use to the metrics of status.field and status parameters}
  \item{\code{getFilenamesStatusMode(mode,sources = sort(unique(self$df$source)),max.quant = 0,order.by.vertices.faces = FALSE)}}{Get a list of the filenames in the ledger with a defined mode (status agrupation)}
  \item{\code{getFilenamesStatus(status,sources = sort(unique(self$df$source)),max.quant = 0,order.by.vertices.faces = FALSE)}}{Get a list of the filenames in the ledger with specified status}
}
}

\keyword{datasets}
