% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_management.R
\name{check_form}
\alias{check_form}
\title{Check model formula}
\usage{
check_form(form, re = NULL, ordered = FALSE)
}
\arguments{
\item{form}{A \code{formula} object that is used to specify the model equation.
The structure is \code{choice ~ A | B | C}, where
\itemize{
\item \code{choice} is the name of the dependent variable (the choices),
\item \code{A} are names of alternative and choice situation specific
covariates with a coefficient that is constant across alternatives,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}

Multiple covariates (of one type) are separated by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model.
They can be removed by adding \code{+0} in the second spot.

In the ordered probit model (\code{ordered = TRUE}), the \code{formula}
object has the simple structure \code{choice ~ A}. ASCs are not estimated.}

\item{re}{A character (vector) of covariates of \code{form} with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the ASCs, include \code{"ASC"} in \code{re}.}

\item{ordered}{A boolean, \code{FALSE} per default. If \code{TRUE}, the choice set
\code{alternatives} is assumed to be ordered from worst to best.}
}
\value{
A list that contains the following elements:
\itemize{
\item The input \code{form}.
\item The name \code{choice} of the dependent variable in \code{form}.
\item The input \code{re}.
\item A list \code{vars} of three character vectors of covariate names of
the three covariate types.
\item A boolean \code{ASC}, determining whether the model has ASCs.
}
}
\description{
This function checks the input \code{form}.
}
\examples{
form <- choice ~ price + time + comfort + change
re <- c("price", "time")
RprobitB:::check_form(form = form, re = re)

}
\seealso{
\code{\link[=overview_effects]{overview_effects()}} for an overview of the model effects
}
