% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{saga_remove_tmpfiles}
\alias{saga_remove_tmpfiles}
\title{Removes temporary files created by Rsagacmd}
\usage{
saga_remove_tmpfiles(h = 0)
}
\arguments{
\item{h}{Remove temporary files that are older than h (in number of hours)}
}
\value{
Nothing is returned
}
\description{
For convenience, functions in the Rsagacmd package create temporary files if any outputs for a
SAGA-GIS tool are not specified as arguments. Temporary files in R are automatically removed at
the end of each session. However, when dealing with raster data, these temporary files
potentially can consume large amounts of disk space. These temporary files can be observed during
a session by using the saga_show_tmpfiles function, and can be removed using the
saga_remove_tmpfiles function. Note that this function also removes any accompanying files, i.e.
the '.prj' and '.shx' files that may be written as part of writing a ESRI Shapefile '.shp'
format.
}
\examples{
# Remove all temporary files generated by Rsagacmd
saga_remove_tmpfiles(h = 0)
}
