% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_strategies.R
\name{threshold_strategies}
\alias{threshold_strategies}
\title{Subset an rtrack_strategies object.}
\usage{
threshold_strategies(strategies, threshold = NULL)
}
\arguments{
\item{strategies}{An \code{rtrack_strategies} object as generated by
\code{\link{call_strategy}}.}

\item{threshold}{A numeric value between 0 and 1 or a logical value depending
on the strategy-calling method used (see Details).}
}
\value{
An \code{rtrack_strategies} object including only above-threshold
  calls. In addition, the component \code{thresholded} is set to \code{TRUE}
  if thresholding was performed.
}
\description{
Subsets strategy calls based on a threshold.
}
\details{
For strategy-calling algorithms yielding a confidence score (such as
\code{\link{call_strategy}}), a value between 0 and 1 will return a new
\code{rtrack_strategies} object only including calls with a confidence score
above the given threshold. For strategy-calling algorithms that include a '0'
or 'unknown' strategy, (such as \code{\link{call_mwm_strategy_garthe}}),
\code{TRUE} will remove these unknown strategies while \code{FALSE} will
return an unchanged \code{rtrack_strategies} object.
}
\examples{
require(Rtrack)
track_file <- system.file("extdata", "Track_1.csv", package = "Rtrack")
arena_description <- system.file("extdata", "Arena_SW.txt", package = "Rtrack")
arena <- read_arena(arena_description)
path <- read_path(track_file, arena, track.format = "ethovision.3.csv")
metrics <- calculate_metrics(path, arena)
strategies <- call_strategy(metrics)
# Inspect the strategy call (minimal experiment only has one track)
strategies$calls
# Thresholding at 0.4 will retain the track (confidence = 0.58)
strategies = threshold_strategies(strategies, threshold = 0.4)
strategies$calls
# Thresholding at 0.6 will discard the track, still returning an (empty) rtrack_strategies object
strategies = threshold_strategies(strategies, threshold = 0.6)
strategies$calls

}
