% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{empdis}
\alias{empdis}
\title{empdis: Empirical Distribution Function}
\usage{
empdis(x, nyr)
}
\arguments{
\item{x}{A numeric vector representing the dataset.}

\item{nyr}{An integer representing the number of years in the dataset.}
}
\value{
A data frame containing:
\describe{
\item{\code{emp.RP}}{empirical return period}
\item{\code{haz.RP}}{Hazen return period}
\item{\code{cun.RP}}{Cunnane return period}
\item{\code{gumbel}}{Gumbel values}
\item{\code{emp.f}}{empirical cumulative density}
\item{\code{emp.hazen}}{Hazen cumulative density}
\item{\code{emp.cunnan}}{Cunnane cumulative density}
\item{\code{Q}}{original data}
\item{\code{timestamp}}{time component}
}
}
\description{
\code{empdis} is a function that calculates the empirical
distribution function for a given dataset.
}
\examples{
x <- c(1, 2, 3, 4, 5)
nyr <- 5
empdis(x, nyr)

}
