require(RxODE);
context("Example 6")
require(digest)


inf.dat <- structure(list(time = c(0, 0.0417, 0.0833, 0.125, 0.1667, 0.2083, 0.25, 0.2917, 0.3333, 0.375, 0.4167, 0.4583, 0.5, 0.5417, 0.5833, 0.625, 0.6667, 0.7083, 0.75, 0.7917, 0.8333, 0.875, 0.9167, 0.9583, 1, 1.0417, 1.0833, 1.125, 1.1667, 1.2083, 1.25, 1.2917, 1.3333, 1.375, 1.4167, 1.4583, 1.5, 1.5417, 1.5833, 1.625, 1.6667, 1.7083, 1.75, 1.7917, 1.8333, 1.875, 1.9167, 1.9583, 2, 2.0417, 2.0833, 2.125, 2.1667, 2.2083, 2.25, 2.2917, 2.3333, 2.375, 2.4167, 2.4583, 2.5, 2.5417, 2.5833, 2.625, 2.6667, 2.7083, 2.75, 2.7917, 2.8333, 2.875, 2.9167, 2.9583, 3, 3.0417, 3.0833, 3.125, 3.1667, 3.2083, 3.25, 3.2917, 3.3333, 3.375, 3.4167, 3.4583, 3.5, 3.5417, 3.5833, 3.625, 3.6667, 3.7083, 3.75, 3.7917, 3.8333, 3.875, 3.9167, 3.9583, 4, 4.0417, 4.0833, 4.125, 4.1667, 4.2083, 4.25, 4.2917, 4.3333, 4.375, 4.4167, 4.4583, 4.5, 4.5417, 4.5833, 4.625, 4.6667, 4.7083, 4.75, 4.7917, 4.8333, 4.875, 4.9167, 4.9583, 5, 5.0417, 5.0833, 5.125, 5.1667, 5.2083, 5.25, 5.2917, 5.3333, 5.375, 5.4167, 5.4583, 5.5, 5.5417, 5.5833, 5.625, 5.6667, 5.7083, 5.75, 5.7917, 5.8333, 5.875, 5.9167, 5.9583, 6, 6.0417, 6.0833, 6.125, 6.1667, 6.2083, 6.25, 6.2917, 6.3333, 6.375, 6.4167, 6.4583, 6.5, 6.5417, 6.5833, 6.625, 6.6667, 6.7083, 6.75, 6.7917, 6.8333, 6.875, 6.9167, 6.9583, 7, 7.0417, 7.0833, 7.125, 7.1667, 7.2083, 7.25, 7.2917, 7.3333, 7.375, 7.4167, 7.4583, 7.5, 7.5417, 7.5833, 7.625, 7.6667, 7.7083, 7.75, 7.7917, 7.8333, 7.875, 7.9167, 7.9583, 8, 8.0417, 8.0833, 8.125, 8.1667, 8.2083, 8.25, 8.2917, 8.3333, 8.375, 8.4167, 8.4583, 8.5, 8.5417, 8.5833, 8.625, 8.6667, 8.7083, 8.75, 8.7917, 8.8333, 8.875, 8.9167, 8.9583, 9, 9.0417, 9.0833, 9.125, 9.1667, 9.2083, 9.25, 9.2917, 9.3333, 9.375, 9.4167, 9.4583, 9.5, 9.5417, 9.5833, 9.625, 9.6667, 9.7083, 9.75, 9.7917, 9.8333, 9.875, 9.9167, 9.9583, 10), intestine = c(0, 0.0737, 0.0574, 0.0447, 0.0348, 0.0271, 0.0211, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272, 0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272, 0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272, 0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272, 0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272, 0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272, 0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272, 0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272, 0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272, 0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037, 0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04, 4e-04, 3e-04, 2e-04), blood = c(0, 0.0095, 0.0254, 0.0373, 0.0461, 0.0526, 0.0572, 0.0604, 0.0625, 0.0638, 0.0644, 0.0645, 0.0642, 0.0637, 0.0629, 0.062, 0.0609, 0.0598, 0.0586, 0.0574, 0.0562, 0.0549, 0.0537, 0.0524, 0.0512, 0.0595, 0.0742, 0.0849, 0.0926, 0.0979, 0.1015, 0.1036, 0.1046, 0.1048, 0.1044, 0.1036, 0.1023, 0.1008, 0.0991, 0.0973, 0.0954, 0.0934, 0.0914, 0.0894, 0.0874, 0.0853, 0.0834, 0.0814, 0.0794, 0.087, 0.101, 0.1111, 0.1182, 0.1229, 0.1258, 0.1273, 0.1277, 0.1274, 0.1264, 0.125, 0.1232, 0.1212, 0.119, 0.1167, 0.1143, 0.1119, 0.1094, 0.107, 0.1045, 0.1021, 0.0996, 0.0973, 0.0949, 0.1022, 0.1158, 0.1255, 0.1322, 0.1365, 0.1391, 0.1403, 0.1404, 0.1398, 0.1385, 0.1368, 0.1347, 0.1324, 0.13, 0.1274, 0.1247, 0.122, 0.1193, 0.1166, 0.1139, 0.1112, 0.1086, 0.106, 0.1034, 0.1105, 0.1239, 0.1334, 0.1399, 0.144, 0.1464, 0.1474, 0.1474, 0.1466, 0.1451, 0.1432, 0.141, 0.1386, 0.136, 0.1332, 0.1304, 0.1276, 0.1247, 0.1219, 0.1191, 0.1163, 0.1135, 0.1108, 0.1081, 0.115, 0.1283, 0.1377, 0.1441, 0.1482, 0.1504, 0.1514, 0.1512, 0.1503, 0.1488, 0.1468, 0.1445, 0.142, 0.1393, 0.1364, 0.1336, 0.1306, 0.1277, 0.1248, 0.1219, 0.119, 0.1162, 0.1134, 0.1107, 0.1175, 0.1307, 0.1401, 0.1464, 0.1504, 0.1526, 0.1535, 0.1533, 0.1523, 0.1508, 0.1487, 0.1464, 0.1438, 0.1411, 0.1382, 0.1353, 0.1323, 0.1293, 0.1264, 0.1234, 0.1205, 0.1177, 0.1148, 0.1121, 0.1189, 0.1321, 0.1414, 0.1477, 0.1517, 0.1539, 0.1547, 0.1545, 0.1535, 0.1519, 0.1498, 0.1474, 0.1448, 0.142, 0.1392, 0.1362, 0.1332, 0.1302, 0.1273, 0.1243, 0.1214, 0.1185, 0.1156, 0.1128, 0.1196, 0.1328, 0.1421, 0.1484, 0.1523, 0.1545, 0.1553, 0.1551, 0.1541, 0.1525, 0.1504, 0.148, 0.1454, 0.1426, 0.1397, 0.1367, 0.1337, 0.1307, 0.1277, 0.1248, 0.1218, 0.1189, 0.1161, 0.1133, 0.12, 0.1332, 0.1425, 0.1488, 0.1527, 0.1549, 0.1557, 0.1554, 0.1544, 0.1528, 0.1507, 0.1483, 0.1457, 0.1429, 0.14, 0.137, 0.134, 0.131, 0.128, 0.125, 0.1221, 0.1192, 0.1163, 0.1135)), .Names = c("time", "intestine", "blood"), row.names = c(NA, -241L), class = "data.frame")

inf.dat2 <- structure(list(time = c(0, 0.0417, 0.0833, 0.125, 0.1667, 0.2083, 0.25, 0.2917, 0.3333, 0.375, 0.4167, 0.4583, 0.5, 0.5417, 0.5833, 0.625, 0.6667, 0.7083, 0.75, 0.7917, 0.8333, 0.875, 0.9167, 0.9583, 1, 1.0417, 1.0833, 1.125, 1.1667, 1.2083, 1.25, 1.2917, 1.3333, 1.375, 1.4167, 1.4583, 1.5, 1.5417, 1.5833, 1.625, 1.6667, 1.7083, 1.75, 1.7917, 1.8333, 1.875, 1.9167, 1.9583, 2, 2.0417, 2.0833, 2.125, 2.1667, 2.2083, 2.25, 2.2917, 2.3333, 2.375, 2.4167, 2.4583, 2.5, 2.5417, 2.5833, 2.625, 2.6667, 2.7083, 2.75, 2.7917, 2.8333, 2.875, 2.9167, 2.9583, 3, 3.0417, 3.0833, 3.125, 3.1667, 3.2083, 3.25, 3.2917, 3.3333, 3.375, 3.4167, 3.4583, 3.5, 3.5417, 3.5833, 3.625, 3.6667, 3.7083, 3.75, 3.7917, 3.8333, 3.875, 3.9167, 3.9583, 4, 4.0417, 4.0833, 4.125, 4.1667, 4.2083, 4.25, 4.2917, 4.3333, 4.375, 4.4167, 4.4583, 4.5, 4.5417, 4.5833, 4.625, 4.6667, 4.7083, 4.75, 4.7917, 4.8333, 4.875, 4.9167, 4.9583, 5, 5.0417, 5.0833, 5.125, 5.1667, 5.2083, 5.25, 5.2917, 5.3333, 5.375, 5.4167, 5.4583, 5.5, 5.5417, 5.5833, 5.625, 5.6667, 5.7083, 5.75, 5.7917, 5.8333, 5.875, 5.9167, 5.9583, 6, 6.0417, 6.0833, 6.125, 6.1667, 6.2083, 6.25, 6.2917, 6.3333, 6.375, 6.4167, 6.4583, 6.5, 6.5417, 6.5833, 6.625, 6.6667, 6.7083, 6.75, 6.7917, 6.8333, 6.875, 6.9167, 6.9583, 7, 7.0417, 7.0833, 7.125, 7.1667, 7.2083, 7.25, 7.2917, 7.3333, 7.375, 7.4167, 7.4583, 7.5, 7.5417, 7.5833, 7.625, 7.6667, 7.7083, 7.75, 7.7917, 7.8333, 7.875, 7.9167, 7.9583, 8, 8.0417, 8.0833, 8.125, 8.1667, 8.2083, 8.25, 8.2917, 8.3333, 8.375, 8.4167, 8.4583, 8.5, 8.5417, 8.5833, 8.625, 8.6667, 8.7083, 8.75, 8.7917, 8.8333, 8.875, 8.9167, 8.9583, 9, 9.0417, 9.0833, 9.125, 9.1667, 9.2083, 9.25, 9.2917, 9.3333, 9.375, 9.4167, 9.4583, 9.5, 9.5417, 9.5833, 9.625, 9.6667, 9.7083, 9.75, 9.7917, 9.8333, 9.875, 9.9167, 9.9583, 10), intestine = c(0, 0.0737, 0.0574, 0.0447, 0.0348, 0.0271, 0.0211, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0774, 0.0603, 0.0469, 0.0366, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.0049, 0.0776, 0.0604, 0.0471, 0.0366, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0039, 0.003, 0.0023, 0.0018, 0.0014, 0.0011, 9e-04, 7e-04, 5e-04, 4e-04, 3e-04, 2e-04, 2e-04, 1e-04, 1e-04, 1e-04, 1e-04, 1e-04, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), blood = c(0, 0.0095, 0.0254, 0.0373, 0.0461, 0.0526, 0.0572, 0.0604, 0.0625, 0.0638, 0.0644, 0.0645, 0.0642, 0.0732, 0.0883, 0.0993, 0.1071, 0.1124, 0.1158, 0.1178, 0.1187, 0.1187, 0.118, 0.1169, 0.1154, 0.1232, 0.1371, 0.1469, 0.1535, 0.1577, 0.1601, 0.161, 0.1608, 0.1598, 0.1581, 0.156, 0.1535, 0.1603, 0.1733, 0.1822, 0.188, 0.1914, 0.1929, 0.193, 0.192, 0.1902, 0.1878, 0.1849, 0.1818, 0.1879, 0.2002, 0.2084, 0.2136, 0.2163, 0.2172, 0.2167, 0.2151, 0.2127, 0.2098, 0.2064, 0.2027, 0.2083, 0.2201, 0.2278, 0.2325, 0.2348, 0.2352, 0.2342, 0.2322, 0.2294, 0.2261, 0.2223, 0.2182, 0.2234, 0.2348, 0.2422, 0.2465, 0.2484, 0.2485, 0.2473, 0.2449, 0.2418, 0.2381, 0.2341, 0.2297, 0.2346, 0.2457, 0.2529, 0.2569, 0.2586, 0.2584, 0.2569, 0.2543, 0.251, 0.2471, 0.2428, 0.2382, 0.2429, 0.2538, 0.2608, 0.2646, 0.2661, 0.2657, 0.264, 0.2613, 0.2578, 0.2537, 0.2492, 0.2445, 0.249, 0.2598, 0.2666, 0.2703, 0.2716, 0.2712, 0.2693, 0.2664, 0.2628, 0.2586, 0.254, 0.2491, 0.2441, 0.2389, 0.2336, 0.2284, 0.2231, 0.2179, 0.2128, 0.2077, 0.2028, 0.1979, 0.1931, 0.1884, 0.1838, 0.1793, 0.1749, 0.1706, 0.1664, 0.1623, 0.1583, 0.1544, 0.1506, 0.1469, 0.1433, 0.1397, 0.1363, 0.1329, 0.1297, 0.1265, 0.1233, 0.1203, 0.1173, 0.1144, 0.1116, 0.1088, 0.1062, 0.1035, 0.101, 0.0985, 0.0961, 0.0937, 0.0914, 0.0891, 0.0869, 0.0848, 0.0827, 0.0806, 0.0786, 0.0767, 0.0748, 0.073, 0.0712, 0.0694, 0.0677, 0.066, 0.0644, 0.0628, 0.0612, 0.0597, 0.0583, 0.0568, 0.0554, 0.054, 0.0527, 0.0514, 0.0501, 0.0489, 0.0477, 0.0465, 0.0454, 0.0443, 0.0432, 0.0421, 0.0411, 0.04, 0.0391, 0.0381, 0.0371, 0.0362, 0.0353, 0.0345, 0.0336, 0.0328, 0.032, 0.0312, 0.0304, 0.0297, 0.0289, 0.0282, 0.0275, 0.0268, 0.0262, 0.0255, 0.0249, 0.0243, 0.0237, 0.0231, 0.0225, 0.022, 0.0214, 0.0209, 0.0204, 0.0199, 0.0194, 0.0189, 0.0184, 0.018, 0.0175, 0.0171, 0.0167, 0.0163, 0.0159, 0.0155, 0.0151, 0.0147, 0.0144, 0.014, 0.0137, 0.0133, 0.013, 0.0127)), .Names = c("time", "intestine", "blood"), row.names = c(NA, -241L), class = "data.frame")

dat3 <- structure(list(time = c(0, 0.0417, 0.0833, 0.125, 0.1667, 0.2083, 0.25, 0.2917, 0.3333, 0.375, 0.4167, 0.4583, 0.5, 0.5417, 0.5833, 0.625, 0.6667, 0.7083, 0.75, 0.7917, 0.8333, 0.875, 0.9167, 0.9583, 1, 1.0417, 1.0833, 1.125, 1.1667, 1.2083, 1.25, 1.2917, 1.3333, 1.375, 1.4167, 1.4583, 1.5, 1.5417, 1.5833, 1.625, 1.6667, 1.7083, 1.75, 1.7917, 1.8333, 1.875, 1.9167, 1.9583, 2, 2.0417, 2.0833, 2.125, 2.1667, 2.2083, 2.25, 2.2917, 2.3333, 2.375, 2.4167, 2.4583, 2.5, 2.5417, 2.5833, 2.625, 2.6667, 2.7083, 2.75, 2.7917, 2.8333, 2.875, 2.9167, 2.9583, 3, 3.0417, 3.0833, 3.125, 3.1667, 3.2083, 3.25, 3.2917, 3.3333, 3.375, 3.4167, 3.4583, 3.5, 3.5417, 3.5833, 3.625, 3.6667, 3.7083, 3.75, 3.7917, 3.8333, 3.875, 3.9167, 3.9583, 4, 4.0417, 4.0833, 4.125, 4.1667, 4.2083, 4.25, 4.2917, 4.3333, 4.375, 4.4167, 4.4583, 4.5, 4.5417, 4.5833, 4.625, 4.6667, 4.7083, 4.75, 4.7917, 4.8333, 4.875, 4.9167, 4.9583, 5, 5.0417, 5.0833, 5.125, 5.1667, 5.2083, 5.25, 5.2917, 5.3333, 5.375, 5.4167, 5.4583, 5.5, 5.5417, 5.5833, 5.625, 5.6667, 5.7083, 5.75, 5.7917, 5.8333, 5.875, 5.9167, 5.9583, 6, 6.0417, 6.0833, 6.125, 6.1667, 6.2083, 6.25, 6.2917, 6.3333, 6.375, 6.4167, 6.4583, 6.5, 6.5417, 6.5833, 6.625, 6.6667, 6.7083, 6.75, 6.7917, 6.8333, 6.875, 6.9167, 6.9583, 7, 7.0417, 7.0833, 7.125, 7.1667, 7.2083, 7.25, 7.2917, 7.3333, 7.375, 7.4167, 7.4583, 7.5, 7.5417, 7.5833, 7.625, 7.6667, 7.7083, 7.75, 7.7917, 7.8333, 7.875, 7.9167, 7.9583, 8, 8.0417, 8.0833, 8.125, 8.1667, 8.2083, 8.25, 8.2917, 8.3333, 8.375, 8.4167, 8.4583, 8.5, 8.5417, 8.5833, 8.625, 8.6667, 8.7083, 8.75, 8.7917, 8.8333, 8.875, 8.9167, 8.9583, 9, 9.0417, 9.0833, 9.125, 9.1667, 9.2083, 9.25, 9.2917, 9.3333, 9.375, 9.4167, 9.4583, 9.5, 9.5417, 9.5833, 9.625, 9.6667, 9.7083, 9.75, 9.7917, 9.8333, 9.875, 9.9167, 9.9583, 10), blood = c(40, 39.0124, 38.0491, 37.1097, 36.1935, 35.2999, 34.4284, 33.5783, 32.7493, 31.9407, 31.1521, 30.3829, 29.6328, 28.9011, 28.1876, 27.4916, 26.8128, 26.1508, 25.5051, 24.8754, 24.2612, 23.6622, 23.078, 22.5082, 61.9525, 60.4229, 58.931, 57.476, 56.057, 54.6729, 53.3231, 52.0065, 50.7225, 49.4701, 48.2487, 47.0574, 45.8956, 44.7624, 43.6572, 42.5793, 41.528, 40.5027, 39.5027, 38.5274, 37.5761, 36.6484, 35.7435, 34.861, 74.0003, 72.1732, 70.3912, 68.6533, 66.9583, 65.3051, 63.6927, 62.1201, 60.5864, 59.0905, 57.6316, 56.2086, 54.8208, 53.4673, 52.1472, 50.8597, 49.6039, 48.3792, 47.1847, 46.0197, 44.8835, 43.7753, 42.6945, 41.6404, 80.6123, 78.622, 76.6807, 74.7875, 72.9411, 71.1402, 69.3837, 67.6706, 65.9999, 64.3703, 62.781, 61.2309, 59.7191, 58.2447, 56.8066, 55.404, 54.0361, 52.7019, 51.4007, 50.1316, 48.8939, 47.6867, 46.5093, 45.361, 84.241, 82.1611, 80.1325, 78.1541, 76.2245, 74.3426, 72.507, 70.7168, 68.9708, 67.2679, 65.6071, 63.9872, 62.4074, 60.8666, 59.3637, 57.898, 56.4685, 55.0743, 53.7145, 52.3883, 51.0948, 49.8333, 48.6029, 47.4029, 86.2325, 84.1035, 82.0269, 80.0017, 78.0265, 76.1001, 74.2211, 72.3886, 70.6013, 68.8582, 67.1581, 65.4999, 63.8827, 62.3055, 60.7671, 59.2668, 57.8035, 56.3763, 54.9844, 53.6268, 52.3027, 51.0114, 49.7519, 48.5235, 87.3255, 85.1694, 83.0665, 81.0157, 79.0155, 77.0646, 75.1619, 73.3061, 71.4962, 69.731, 68.0093, 66.3301, 64.6924, 63.0952, 61.5373, 60.018, 58.5361, 57.0908, 55.6813, 54.3065, 52.9657, 51.6579, 50.3825, 49.1385, 87.9253, 85.7545, 83.6371, 81.5722, 79.5583, 77.594, 75.6782, 73.8097, 71.9873, 70.2099, 68.4764, 66.7858, 65.1368, 63.5286, 61.96, 60.4302, 58.9382, 57.483, 56.0637, 54.6795, 53.3295, 52.0128, 50.7286, 49.4761, 88.2545, 86.0755, 83.9503, 81.8776, 79.8561, 77.8845, 75.9615, 74.086, 72.2568, 70.4728, 68.7328, 67.0358, 65.3807, 63.7664, 62.192, 60.6565, 59.1589, 57.6982, 56.2736, 54.8842, 53.5291, 52.2075, 50.9185, 49.6613, 88.4352, 86.2517, 84.1221, 82.0452, 80.0196, 78.0439, 76.117, 74.2377, 72.4047, 70.6171, 68.8735, 67.173, 65.5145, 63.897, 62.3193, 60.7807, 59.28, 57.8163, 56.3888, 54.9966, 53.6387, 52.3144, 51.0227, 49.763, 88.5343)), .Names = c("time", "blood"), row.names = c(NA, -241L), class = "data.frame")

dat4 <- structure(list(time = c(0, 0.0417, 0.0833, 0.125, 0.1667, 0.2083, 0.25, 0.2917, 0.3333, 0.375, 0.4167, 0.4583, 0.5, 0.5417, 0.5833, 0.625, 0.6667, 0.7083, 0.75, 0.7917, 0.8333, 0.875, 0.9167, 0.9583, 1, 1.0417, 1.0833, 1.125, 1.1667, 1.2083, 1.25, 1.2917, 1.3333, 1.375, 1.4167, 1.4583, 1.5, 1.5417, 1.5833, 1.625, 1.6667, 1.7083, 1.75, 1.7917, 1.8333, 1.875, 1.9167, 1.9583, 2, 2.0417, 2.0833, 2.125, 2.1667, 2.2083, 2.25, 2.2917, 2.3333, 2.375, 2.4167, 2.4583, 2.5, 2.5417, 2.5833, 2.625, 2.6667, 2.7083, 2.75, 2.7917, 2.8333, 2.875, 2.9167, 2.9583, 3, 3.0417, 3.0833, 3.125, 3.1667, 3.2083, 3.25, 3.2917, 3.3333, 3.375, 3.4167, 3.4583, 3.5, 3.5417, 3.5833, 3.625, 3.6667, 3.7083, 3.75, 3.7917, 3.8333, 3.875, 3.9167, 3.9583, 4, 4.0417, 4.0833, 4.125, 4.1667, 4.2083, 4.25, 4.2917, 4.3333, 4.375, 4.4167, 4.4583, 4.5, 4.5417, 4.5833, 4.625, 4.6667, 4.7083, 4.75, 4.7917, 4.8333, 4.875, 4.9167, 4.9583, 5, 5.0417, 5.0833, 5.125, 5.1667, 5.2083, 5.25, 5.2917, 5.3333, 5.375, 5.4167, 5.4583, 5.5, 5.5417, 5.5833, 5.625, 5.6667, 5.7083, 5.75, 5.7917, 5.8333, 5.875, 5.9167, 5.9583, 6, 6.0417, 6.0833, 6.125, 6.1667, 6.2083, 6.25, 6.2917, 6.3333, 6.375, 6.4167, 6.4583, 6.5, 6.5417, 6.5833, 6.625, 6.6667, 6.7083, 6.75, 6.7917, 6.8333, 6.875, 6.9167, 6.9583, 7, 7.0417, 7.0833, 7.125, 7.1667, 7.2083, 7.25, 7.2917, 7.3333, 7.375, 7.4167, 7.4583, 7.5, 7.5417, 7.5833, 7.625, 7.6667, 7.7083, 7.75, 7.7917, 7.8333, 7.875, 7.9167, 7.9583, 8, 8.0417, 8.0833, 8.125, 8.1667, 8.2083, 8.25, 8.2917, 8.3333, 8.375, 8.4167, 8.4583, 8.5, 8.5417, 8.5833, 8.625, 8.6667, 8.7083, 8.75, 8.7917, 8.8333, 8.875, 8.9167, 8.9583, 9, 9.0417, 9.0833, 9.125, 9.1667, 9.2083, 9.25, 9.2917, 9.3333, 9.375, 9.4167, 9.4583, 9.5, 9.5417, 9.5833, 9.625, 9.6667, 9.7083, 9.75, 9.7917, 9.8333, 9.875, 9.9167, 9.9583, 10), blood = c(40, 39.0124, 38.0491, 37.1097, 36.1935, 35.2999, 34.4284, 33.5783, 32.7493, 31.9407, 31.1521, 30.3829, 69.6328, 67.9135, 66.2367, 64.6013, 63.0064, 61.4508, 59.9335, 58.4538, 57.0106, 55.603, 54.2301, 52.8912, 91.5853, 89.324, 87.1186, 84.9677, 82.8699, 80.8238, 78.8283, 76.882, 74.9838, 73.1324, 71.3268, 69.5657, 107.8482, 105.1854, 102.5883, 100.0555, 97.5852, 95.1758, 92.8259, 90.534, 88.2987, 86.1186, 83.9924, 81.9186, 119.896, 116.9358, 114.0486, 111.2328, 108.4866, 105.808, 103.1956, 100.6477, 98.1627, 95.7391, 93.3753, 91.0698, 128.8213, 125.6407, 122.5386, 119.5132, 116.5625, 113.6846, 110.8777, 108.1401, 105.4702, 102.8661, 100.3263, 97.8493, 135.4334, 132.0895, 128.8282, 125.6475, 122.5454, 119.5197, 116.5688, 113.6907, 110.8837, 108.1459, 105.4758, 102.8716, 140.3317, 136.8669, 133.4876, 130.1919, 126.9776, 123.8425, 120.7848, 117.8026, 114.8941, 112.0574, 109.2907, 106.5923, 143.9605, 140.4061, 136.9394, 133.5585, 130.2611, 127.0449, 123.9082, 120.8489, 117.8651, 114.955, 112.1168, 109.3486, 146.6488, 143.0281, 139.4966, 136.0525, 132.6935, 129.4173, 126.222, 123.1056, 120.0661, 117.1017, 114.2104, 111.3906, 148.6403, 144.9704, 141.391, 137.9002, 134.4956, 131.1749, 127.9361, 124.7774, 121.6966, 118.692, 115.7614, 112.9033, 150.1157, 146.4094, 142.7944, 139.269, 135.8305, 132.4769, 129.206, 126.0159, 122.9046, 119.8701, 116.9105, 114.0239, 151.2087, 147.4754, 143.8341, 140.283, 136.8195, 133.4414, 130.1468, 126.9334, 123.7994, 120.7428, 117.7617, 114.8541, 152.0184, 148.2651, 144.6043, 141.0342, 137.5522, 134.156, 130.8437, 127.6131, 124.4624, 121.3894, 118.3923, 115.4692, 152.6182, 148.8501, 145.1749, 141.5907, 138.0949, 134.6854, 131.36, 128.1167, 124.9535, 121.8684, 118.8595, 115.9248, 153.0626, 149.2836, 145.5976, 142.003, 138.497, 135.0775, 131.7425, 128.4897, 125.3173, 122.2232, 119.2055, 116.2624, 153.3918, 149.6046, 145.9108, 142.3084, 138.7949, 135.3681, 132.0258, 128.7661, 125.5869, 122.4861, 119.4619, 116.5124, 153.6357, 149.8425, 146.1428, 142.5346, 139.0156, 135.5833, 132.2357, 128.9708, 125.7865, 122.6809, 119.6519, 116.6977, 153.8164, 150.0187, 146.3146, 142.7023, 139.1791, 135.7427, 132.3912, 129.1225, 125.9345, 122.8251, 119.7926, 116.8349, 153.9502, 150.1493, 146.442, 142.8264, 139.3002, 135.8609, 132.5064, 129.2349, 126.044, 122.932, 119.8968, 116.9366, 114.0494)), row.names = c(NA, -241L), .Names = c("time", "blood"), class = "data.frame")

rxPermissive({
    ## https://cran.r-project.org/web/packages/diffEq/vignettes/ODEinR.pdf p11

    ## 6.1
    mod <- RxODE("
a = 6
b = 0.6
d/dt(intestine) = -a*intestine
d/dt(blood)     = a*intestine - b*blood
")

    et <- eventTable(time.units="days")
    et$add.sampling(seq(0,10,by=1/24))
    et$add.dosing(dose=2/24,rate=2,strt.time=0,
                  nbr.doses=10,dosing.interval=1)

    pk <- solve(mod,et);

    ## plot(pk$time,pk$intestine,type="l")
    ## plot(pk$time,pk$blood,type="l")
    test_that("infusion model works.",{
        expect_equal(round(as.data.frame(pk),4), inf.dat)
    })

    pk2 <- solve(mod, et, matrix=TRUE)
    test_that("matrix solving works.",{
        expect_equal(as.matrix(pk),pk2)
    })

    ## Change QD dosing to BID dosing.
    et2 <- eventTable(time.units="days")
    et2$add.sampling(seq(0,10,by=1/24))
    et2$add.dosing(dose=2/24,rate=2,strt.time=0,
                   nbr.doses=10,dosing.interval=0.5)

    pk2 <- pk + et2;

    ## plot(pk2$time,pk2$intestine,type="l")
    ## plot(pk2$time,pk2$blood,type="l")

    test_that("bid infusion works.",{
        expect_equal(round(as.data.frame(pk2),4),
                     inf.dat2)
    })


    ## Bolus 6.2
    mod <- RxODE("
b = 0.6
d/dt(blood) = - b*blood
")

    et <- eventTable(time.units="days")
    et$add.sampling(seq(0,10,by=1/24));
    et$add.dosing(start.time=0,dose=40,nbr.doses=20,dosing.interval=1);

    pk <- solve(mod,et)

    ## plot(pk$time,pk$blood,type="l")

    test_that("bolus model works",{
        expect_equal(round(as.data.frame(pk),4), dat3)
    })

    et2 <- eventTable(time.units="days")
    et2$add.sampling(seq(0,10,by=1/24));
    et2$add.dosing(start.time=0,dose=40,nbr.doses=20,dosing.interval=0.5);

    pk2 <- rxChain(pk,et2);

    ## plot(pk2$time,pk2$blood,type="l")

    test_that("bolus model bid works",{
        expect_equal(round(as.data.frame(pk2),4), dat4)
    })

    rxClean()
}, silent=TRUE);
