% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxrandom.R
\name{rxpois}
\alias{rxpois}
\title{Simulate random Poisson variable from threefry generator}
\usage{
rxpois(lambda, n = 1L, ncores = 1L)
}
\arguments{
\item{lambda}{vector of (non-negative) means.}

\item{n}{number of random values to return.}

\item{ncores}{Number of cores for the simulation

\code{rxnorm} simulates using the threefry sitmo generator; \code{rxnormV}
uses the vandercorput generator}
}
\value{
poission random number deviates
}
\description{
Care should be taken with this method not to encounter the
birthday problem, described
\url{https://www.johndcook.com/blog/2016/01/29/random-number-generator-seed-mistakes/}.
Since the \code{sitmo} \code{threefry}, this currently generates
one random deviate from the uniform distribution to seed the
engine \code{threefry} and then run the code.
}
\details{
Therefore, a simple call to the random number generated followed by a second
call to random number generated may have identical seeds.  As the number of
random number generator calls are increased the probability that the
birthday problem will increase.

The key to avoid this problem is to either run all simulations in the
\code{RxODE} environment once (therefore one seed or series of seeds
for the whole simulation), pre-generate all random variables
used for the simulation, or seed the RxODE engine with \code{rxSetSeed()}

Also care should be made that the computer you will be running on
can run the same number of cores as you are running so they can
reproduce your results.
}
\examples{
\donttest{
## Use threefry engine

rxpois(lambda = 3, n = 10) # with rxpois you have to explicitly state n
rxpois(lambda = 3, n = 10, ncores = 2) # You can parallelize the simulation using openMP

rxpois(4) ## The first arguments are the lambda parameter


## This example uses `rxpois` directly in the model

rx <- RxODE({
  a <- rxpois(3)
})

et <- et(1, id = 1:2)

s <- rxSolve(rx, et)
}
}
