% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RbfInter.R
\name{trainCubicRBF}
\alias{trainCubicRBF}
\title{Fit cubic RBF interpolation to training data for d>1.}
\usage{
trainCubicRBF(xp, U, squares = FALSE, rho = 0)
}
\arguments{
\item{xp}{n points \eqn{x_i} of dimension d are arranged in (n x d) matrix \code{xp}}

\item{U}{vector of length n, containing samples \eqn{u(x_i)} of
the scalar function \eqn{u} to be fitted \cr
- or - \cr
(n x m) matrix, where each column 1,...,m contains one vector of samples
\eqn{u_j(x_i)} for the m'th model, j=1,...,m}

\item{squares}{[FALSE] flag, see description}

\item{rho}{[0.0] experimental: 0: interpolating, >0, approximating (spline-like)
               Gaussian RBFs}
}
\value{
\code{rbf.model},  an object of class \code{RBFinter}, which is basically a list
with elements:
     \item{coef}{  (n+d+1 x m) matrix holding in column m the coefficients for the m'th
                   model:      \eqn{\lambda_1, ..., \lambda_n, c_0, c_1, ..., c_d}.
                   In case \code{squares==TRUE} it is an (n+2d+1 x m) matrix holding
                   additionally the coefficients \eqn{c_{d+1}, ..., c_{d+d}}.}
     \item{xp}{  matrix xp   }
     \item{d}{  dimension d }
     \item{npts}{  number n of points \eqn{x_i} }
     \item{squares}{  TRUE or FALSE  }
     \item{type}{  "CUBIC"}
}
\description{
The model for a point \eqn{z=(z_1,...,z_d)} is fitted using n sample points \eqn{x_1, ..., x_n}
\cr
   \deqn{ s(z) = \lambda_1*\Phi(||z-x_1||)+... +\lambda_n*\Phi(||z-x_n||)
                 + c_0 + c_1*z_1 + ... + c_d*z_d  }
\cr
where \eqn{\Phi(r)=r^3} denotes the cubic radial basis function. The coefficients \eqn{\lambda_1,
..., \lambda_n, c_0, c_1, ..., c_d} are determined by this training procedure.
This is for the default case \code{squares==FALSE}. In case \code{squares==TRUE}
there are d additional pure square terms and the model is
\cr
   \deqn{ s_{sq}(z) = s(z) + c_{d+1}*z_1^2 + ... + c_{d+d}*z_d^2 }
\cr
}
\details{
The linear equation system is solved via SVD inversion. Near-zero elements
in the diagonal matrix \eqn{D} are set to zero in \eqn{D^{-1}}. This is numerically stable
for rank-deficient systems.
}
\author{
Wolfgang Konen (\email{wolfgang.konen@fh-koeln.de})
}
\seealso{
\code{\link{trainGaussRBF}}, \code{\link{predict.RBFinter}}, \code{\link{interpRBF}}
}

