#' North Atlantic Swordfish dataset
#'
#' An S4 object containing catch and index time series for North Atlantic swordfish.
#'
#' @format An object of class [Data-class].
#' @source ASPIC Software at https://www.mhprager.com/aspic.html
#'
#' @examples
#' data(swordfish)
#'
"swordfish"

#' Pacific cod in Area 5ABCD (Hecate Strait and Queen Charlotte Sound), British Columbia, Canada
#'
#' A list containing an operating model, data set, and priors for updating the operating model
#' using the conditioning model [RCM].
#'
#' @format A list containing an object of class [OM-class], [RCMdata-class], and a list of priors
#' for index catchability.
#' 
#' @references
#' Forrest, R.E., Anderson, S.C., Grandin, C.J., and Starr, P.J. 2020. Assessment of Pacific Cod (Gadus macrocephalus) 
#' for Hecate Strait and Queen Charlotte Sound (Area 5ABCD), and West Coast Vancouver Island (Area 3CD) in 2018. 
#' DFO Can. Sci. Advis. Sec. Res. Doc. 2020/070. v + 215 p.
#' 
#' DFO. 2021. Status Update of Pacifc Cod (Gadus macrocephalus) for West Coast Vancouver Island (Area 3CD), 
#' and Hecate Strait and Queen Charlotte Sound (Area 5ABCD) in 2020. DFO Can. Sci. Advis. Sec. Sci. Resp. 2021/002.
#' @seealso [RCM]
#'
#' @examples
#' data(pcod)
#'
"pcod"

