% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_S4_generic_simulate.R
\name{simulate}
\alias{simulate}
\alias{simulate,Assessment-method}
\alias{simulate.Assessment}
\alias{simulate,RCModel-method}
\alias{simulate.RCModel}
\title{Generate simulated data from TMB models in SAMtool}
\usage{
simulate(object, ...)

\S4method{simulate}{Assessment}(
  object,
  nsim = 1,
  seed = NULL,
  process_error = FALSE,
  refit = FALSE,
  cores = 1,
  ...
)

\S4method{simulate}{RCModel}(
  object,
  nsim = 1,
  seed = NULL,
  process_error = FALSE,
  refit = FALSE,
  cores = 1,
  ...
)
}
\arguments{
\item{object}{An object of class \linkS4class{Assessment} or \linkS4class{RCModel} containing the fitted model.}

\item{...}{Additional arguments}

\item{nsim}{Number of simulations}

\item{seed}{Used for the random number generator}

\item{process_error}{Logical, indicates if process error is re-sampled in the simulation.}

\item{refit}{Logical, whether to re-fit the model for each simulated dataset.}

\item{cores}{The number of CPUs for parallel processing for model re-fitting if \code{refit = TRUE}.}
}
\value{
A \linkS4class{sim} object returning the original data, simulated data, original parameters, parameters estimated
from simulated data, and process error used to simulate data.
then a nested list of model output (\code{opt}, \code{SD}, and \code{report}).
}
\description{
A convenient wrapper function (\code{simulate}) to simulate data (and process error) from the likelihood function.
}
\details{
Process error, e.g., recruitment deviations, will be re-sampled in the simulation.
}
\author{
Q. Huynh
}
