% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_clustering.R
\name{estimate_clustering_vi}
\alias{estimate_clustering_vi}
\alias{plot.vi_clustering}
\alias{print.vi_clustering}
\title{Estimate Posterior Clustering Assignments}
\usage{
estimate_clustering_vi(output, ordered = TRUE)

\method{plot}{vi_clustering}(
  x,
  DC_num = NULL,
  type = c("ecdf", "boxplot", "scatter"),
  palette_brewed = FALSE,
  ...
)

\method{print}{vi_clustering}(x, ...)
}
\arguments{
\item{output}{an object of class \code{SANvb}, the output of one of the variational functions \code{\link{variational_CAM}}, 
\code{\link{variational_fiSAN}}, \code{\link{variational_fSAN}}.}

\item{ordered}{logical, if \code{TRUE} (default), the function sorts the distributional cluster labels reflecting the 
increasing values of medians of the data assigned to each DC.}

\item{x}{an object of class \code{variational_estimates}, which can be obtained from the
function \code{\link{estimate_atoms_weights_vi}}.}

\item{DC_num}{an integer or a vector of integers indicating which distributional clusters to plot.}

\item{type}{what type of plot should be drawn (only for the left-side plot). Possible types are "boxplot", "ecdf", and "scatter".}

\item{palette_brewed}{(logical) the color palette to be used. Default is \code{R} base colors (\code{palette_brewed = FALSE}).}

\item{...}{ignored.}
}
\value{
a list of class \code{clustering} containing 
\itemize{
  \item \code{obs_level}: a data frame containing the data values, their group indexes, the observational and distributional clustering assignments for each observation.
  \item \code{dis_level}: a vector with the distributional clustering assignment for each unit.
}
}
\description{
This function estimates posterior clustering assignments based on posterior variational estimates
obtained from one of the model implemented in SANvi.
}
\examples{
\donttest{
# Generate example data
set.seed(123)
y <- c(rnorm(100),rnorm(100,-5),rnorm(100,5),rnorm(100),
       rnorm(100),rnorm(100,-5),rnorm(100,5),rnorm(100))
g <- rep(1:4,rep(200,4))

# Fitting fiSAN via variational inference
est <- SANvi::variational_fiSAN(y,g,verbose = FALSE)

# Estimate clustering assignments
estimate_clustering_vi(est)
}
}
\seealso{
\code{\link{variational_CAM}}, \code{\link{variational_fiSAN}}, \code{\link{variational_fSAN}}, \code{\link{extract_best}}.
}
