\name{Model_evaluation}
\alias{SCA_Model_evaluation}
\alias{SCE_Model_evaluation}

\title{
  Evaluate SCE and SCA Model Performances
}

\description{
  These functions evaluate the performance of SCE and SCA models using six distinct metrics:
  Mean Absolute Error (MAE), Root Mean Square Error (RMSE), Nash-Sutcliffe Efficiency (NSE),
  Log-transformed NSE, R-squared, and Kling-Gupta Efficiency (KGE). The functions handle both
  single and multiple predictants, with comprehensive input validation and proper handling of
  NaN values and zero/negative values.
}

\usage{
SCA_Model_evaluation(Testing_data, Simulations, Predictant, digits = 3)

SCE_Model_evaluation(Testing_data, Training_data, Simulations, Predictant, digits = 3)
}

\arguments{
  \item{Testing_data}{
    A data.frame containing the observations used during model testing.
    Must include all specified predictants.
  }
  \item{Training_data}{
    A data.frame containing the observations used during model training.
    Required only for SCE_Model_evaluation.
  }
  \item{Simulations}{
    A list containing model predictions:
    \itemize{
      \item For SCE: must contain 'Training', 'Validation', and 'Testing' components
      \item For SCA: must contain 'Testing_sim' component
    }
    The structure should align with the output generated by the respective model training function.
  }
  \item{Predictant}{
    A character vector specifying the name(s) of the dependent variable(s) to be evaluated
    (e.g., c("swvl3", "swvl4")). The specified names must exactly match those used in model training.
  }
  \item{digits}{
    An integer specifying the number of decimal places to retain when reporting
    evaluation metrics. Default value is 3.
  }
}

\value{
  For SCA_Model_evaluation:
  \itemize{
    \item If single predictant: Returns a data.frame with column "Testing"
    \item If multiple predictants: Returns a list of data.frames, one for each predictant
  }
  
  For SCE_Model_evaluation:
  \itemize{
    \item If single predictant: Returns a data.frame with columns "Training", "Validation", and "Testing"
    \item If multiple predictants: Returns a list of data.frames, one for each predictant
  }
  
  Each data.frame contains the following metrics:
  \itemize{
    \item MAE: Mean Absolute Error (mean(abs(obs - sim)))
    \item RMSE: Root Mean Square Error (sqrt(mean((obs - sim)^2)))
    \item NSE: Nash-Sutcliffe Efficiency (1 - (sum((obs - sim)^2) / sum((obs - mean(obs))^2)))
    \item Log.NSE: NSE calculated on log-transformed values
    \item R2: R-squared calculated using linear regression
    \item kge: Kling-Gupta Efficiency (1 - sqrt((r-1)^2 + (alpha-1)^2 + (beta-1)^2))
  }
}

\details{
  The functions perform comprehensive input validation:
  \enumerate{
    \item Data frame structure validation
    \item Presence of required components in Simulations list
    \item Existence of predictants in both data and simulations
    \item Matching row counts between data and simulations
    \item Proper handling of NaN values and zero/negative values
  }
  
  The evaluation process:
  \enumerate{
    \item Removes NaN values from both observed and simulated data
    \item Handles zero or negative values by replacing them with 0.0001
    \item Calculates all six metrics for each predictant
    \item Formats the results with specified number of decimal places
  }
}

\author{
  Kailong Li <lkl98509509@gmail.com>
}

\seealso{
  \code{\link{SCE}}
}
