% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{SDALGCPpolygonpoints}
\alias{SDALGCPpolygonpoints}
\title{SDALGCPpolygonpoints function}
\usage{
SDALGCPpolygonpoints(my_shp, delta, method = 1, pop_shp = NULL,
  weighted = FALSE, rho = NULL, plot = FALSE, giveup = NULL)
}
\arguments{
\item{my_shp}{A SpatialPolygons or SpatialPolygonsDataFrame  object containing the polygons (i.e each regions).}

\item{delta}{distance between points}

\item{method}{To specify which method to use to sample the points, the options are 1 for Simple Sequential Inhibition (SSI) process, 2 for Uniform sampling and 3 for regular grid. 1 is the default}

\item{pop_shp}{Optional, The raster of population density map for population weighted approach}

\item{weighted}{To specify if you want to use the population density, default to FALSE, i.e population density is not used.}

\item{rho}{Optional, The packing density, default set to 0.55}

\item{plot}{To display the plot of the points inside the polygon, default to TRUE}

\item{giveup}{Number of rejected proposals after which the algorithm should terminate.}
}
\value{
It returns a list of the coordinates of the points created in each polygon and it has an associated attribute weighted which is either TRUE or FALSE to indicate if the population density is used or not.
}
\description{
This function generate a random point pattern using Simple Sequential Inhibition (SSI) process, uniform sampling and regular grid point.
}
\details{
This algorithm generates points inside the polygon using three algorithms specified in the method.
}
\seealso{
\link{SDALGCPCreatePoint}, \link{SDALGCPSSIPoint}, \link{SDALGCPUniformPoint}, \link{SDALGCPRegularPoint}
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\keyword{internal}
