% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupfilter.qi.r
\name{dupfilter.qi}
\alias{dupfilter.qi}
\title{Filter temporal duplicates by quality index}
\usage{
dupfilter.qi(sdata, step.time = 0)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
This filter is independently applied to a subset of data grouped by the unique "id". 
"DateTime" is date & time in class POSIXct. "lat" and "lon" are the recorded latitude and longitude in decimal degrees. 
"qi" is the numerical quality index associated with each fix where the greater number represents better quality 
(e.g. number of GPS satellites used for estimation).}

\item{step.time}{A numeric vector specifying temporal interval between two consecutive locations. 
Default is 0 hours. Locations are considered temporal duplicates if the temporal interval is 
less than or equal to the user specified value.}
}
\value{
Input data frame is returned with temporal duplicates removed according to quality index. 
The following columns are added: "pTime", "sTime". "pTime" and "sTime" are hours from a previous and to a subsequent fix respectively.
}
\description{
A partial component of dupfilter, although works as a stand-alone function. 
This function removes temporal duplicates according to the associated quality index.
}
\details{
This function selects a fix from multiple fixes, which were simultaneously obtained but associated with a different level of quality index. 
The fix with the higher quality index is selected over the others.
}
\references{
Shimada T, Limpus C, Jones R, Hazel J, Groom R, Hamann M (2016) 
Sea turtles return home after intentional displacement from coastal foraging areas. 
Marine Biology 163:1-14 doi:10.1007/s00227-015-2771-0
}
\seealso{
dupfilter, dupfilter.exact, dupfilter.time, dupfilter.space
}
\author{
Takahiro Shimada
}
