% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock2.R
\name{clock2}
\alias{clock2}
\title{Spatial cross-validation procedure, CLOCK-2 method}
\usage{
clock2(occ, bg.coords)
}
\arguments{
\item{occ}{Dataframe with longitude (column 1) and latitude (column 2) of the presence-only data. Decimal longitude and latitude are required.}

\item{bg.coords}{Dataframe with longitude (column 1) and latitude (column 2) of the sampled background records. Decimal longitude and latitude are required.}
}
\value{
A list that details the group to which each data (presence or background record) belongs to; and the detail of the random longitude data that was sampled to initiate the CLOCK scheme.
list(occ.grp=occ.grp,bg.coords.grp= bg.coords.grp, tirage)
}
\description{
Cross-validation procedures aims at splitting the initial occurrence dataset into a training subset that is used to build the model and the remaining data can be lately used to test model predictions. Spatially splitting training and test datasets helps reducing the influence of data spatial aggregation on model evaluation performance (Guillaumot et al. 2019, 2021).
}
\details{
See Guillaumot et al.(2019) and vignette tutorial #4 "Spatial cross-validation" for complete examples and details.
}
\examples{
#See Tutorial #4 "Spatial cross-validation"

}
\references{
Guillaumot C, Artois J, Saucède T, Demoustier L, Moreau C, Eléaume M, Agüera A, Danis B (2019). Broad-scale species distribution models applied to data-poor areas. Progress in Oceanography, 175, 198-207.

Guillaumot C, Danis B, Saucède T (2021). Species Distribution Modelling of the Southern Ocean : methods, main limits and some solutions. Antarctic Science.
}
