% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDistMat.R
\name{DDistMat}
\alias{DDistMat}
\title{Double-Power Distance Weights Matrix}
\usage{
DDistMat(distMat, distCutOff = NULL, powr = 2, mevn = FALSE)
}
\arguments{
\item{distMat}{distance matrix}

\item{distCutOff}{distance cutoff. Default = the maximal value from the distance matrix.}

\item{powr}{power (positive exponent), default 2}

\item{mevn}{logical, default FALSE. If TRUE, max-eigenvalue normalization is performed.}
}
\value{
\item{W}{spatial weights matrix (Default, not normalized)}
}
\description{
This function calculates the double-power distance matrix,
for a given distance cutoff and a positive exponent.
}
\details{
W is an \emph{nxn} matrix with elements \eqn{w_{ij}}, \eqn{i, j = 1, ... n}, where
\eqn{w_{ij} = (1-(\frac{d_{ij}}{D})^p)^p}, if \eqn{0 <= d_{ij} < D} and
\eqn{w_{ij} = 0}, if \eqn{d_{ij} > D} or \eqn{i = j}.
\emph{D} is the cut-off distance point (maximum radius of influence),
\eqn{d_{ij}} is the distance between spatial units \emph{i} and \emph{j},
and \emph{p} is the power value (e.g. \emph{p} = 2, 3, 4,...).
}
\examples{
data(gN3dist) ##distance in meters
W1    <- DDistMat(distMat = gN3dist, distCutOff = 300000, powr = 3) ##distance cutoff in meters
dist2 <- gN3dist/1000 ##in km
W2    <- DDistMat(distMat = dist2, 300, 3)  ##distance cutoff in kilometers

}
\author{
Rozeta Simonovska
}
