% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pollen-data.R
\name{create.pollen.sources}
\alias{create.pollen.sources}
\title{Pollen sources emission simulation}
\usage{
create.pollen.sources(nbOfSource = 200, numberOfDay = 60,
  density = runif(1, 7, 11), pollen = rgamma(1, shape = 1.6, scale = 1/(2 *
  10^-7)))
}
\arguments{
\item{nbOfSource}{Number of source fields}

\item{numberOfDay}{Number of days of possible emission}

\item{density}{Plant density plant/m\eqn{^2}}

\item{pollen}{Pollen production grains/plant}
}
\value{
A matrix indexed by sources ID (in rows) and by time ( in columns) whose rows give the values of pollen emission for every source.
}
\description{
Simulate pollen sources emission for maize crop. The proportion of silks 
emitting pollen per day was given by Frédérique Angevin (Angevin et al. 2008).
}

