% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMml.R
\name{getVariableImportance}
\alias{getVariableImportance}
\title{Variable importance for Machine Learning models}
\usage{
getVariableImportance(object, thr = NULL, verbose = FALSE, ...)
}
\arguments{
\item{object}{A model fitting object from \code{SEMml()} function.}

\item{thr}{A numeric value [0-1] indicating the threshold to apply to the
variable importance values to color the graph. If thr = NULL (default), the
threshold is set to thr = 0.5*max(abs(variable importance values)).}

\item{verbose}{A logical value. If FALSE (default), the processed graph 
will not be plotted to screen.}

\item{...}{Currently ignored.}
}
\value{
A list of three object: (i) est: a data.frame including the connections together
with their variable importances (VarImp)), (ii) gest: if the outcome vector is given,
a data.frame of VarImp for outcome lavels, and (iii) dag: DAG with colored edges/nodes.
If abs(VarImp) > thr will be highlighted in red (VarImp > 0) or blue (VarImp < 0). If
the outcome vector is given, nodes with variable importances summed over the outcome
levels, i.e. sum(VarImp[outcome levels])) > thr, will be highlighted in pink.
}
\description{
Extraction of ML variable importance measures.
}
\details{
The variable (predictor) importance will be computed considering:
(i) the absolute value of the z-statistic of the model parameters for "sem";
(ii) the variable importance measures from the \code{\link[rpart]{rpart}},
\code{\link[ranger]{importance}} or \code{\link[xgboost]{xgb.importance}} functions
for "tree", "rf" or "xgb"; and (iii) the Olden's connection weights for "nn" or "dnn"
methods.
}
\examples{

\donttest{
# load ALS data
ig<- alsData$graph
data<- alsData$exprs
data<- transformData(data)$data

#ncores<- parallel::detectCores(logical = FALSE)
ml0<- SEMml(ig, data, outcome=NULL, algo="rf", ncores=2)

vi05<- getVariableImportance(ml0, thr=0.5, verbose=TRUE)
table(E(vi05$dag)$color)
}

}
\references{
add references
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
