% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semWeights.R
\name{weightGraph}
\alias{weightGraph}
\title{Graph weighting methods}
\usage{
weightGraph(graph, data, group = NULL, method = "r2z", limit = 10000, ...)
}
\arguments{
\item{graph}{An igraph object.}

\item{data}{A matrix or data.frame. Rows correspond to subjects, and
columns to graph nodes.}

\item{group}{Binary vector. This vector must be as long as the number
of subjects. Each vector element must be 1 for cases and 0 for control
subjects. By default, \code{group = NULL}. If group is not NULL, also
node weighting is actived, and node weights correspond to the sign
(-1 if z<-2, +1 if z>2, 0 otherwise) and P-value of the z-test = b/SE(b)
from simple linear regression y ~ x (i.e., glm(node ~ group)).}

\item{method}{Edge weighting method. It can be one of the following:
\enumerate{
\item "r2z", weight edges of a graph using Fisher's r-to-z transform 
(Fisher, 1915) to test the correlation coefficient of pairs 
of interacting nodes, if \code{group == NULL}. Otherwise, the correlation
difference between group will be tested and edge weights correspond to
the sign (-1 if z<-2, +1 if z>2, 0 otherwise) and P-value of the group
correlation difference.
\item "sem", edge weights are defined by a SEM model that implies 
testing the group effect simultaneously on the source node and the sink mode.
A new parameter w is defined as the weighted sum of the total effect 
of the group on source and sink nodes, adjusted by node degree centrality, 
and edge weights correspond to the sign (-1 if z<-2, +1 if z>2, 0 otherwise)
and P-value of the z-test = w/SE(w). Not available if \code{group == NULL}.
\item "cov", edge weights are defined by a new parameter w combining 
the group effect on the source node (mean group difference, adjusted 
by source degree centrality), the sink node (mean group difference, 
adjusted by sink degree centrality), and the source-sink interaction 
(correlation difference). Edge weights correspond to the sign
(-1 if z<-2, +1 if z>2, 0 otherwise) and P-value of the z-test = w/SE(w)
of the combined difference of the group over source node, sink node, and
their connection. Not available if \code{group == NULL}.
\item "cfa", edge weights are defined by a CFA1 model that implies 
testing the group effect, w on a latent variable (LV) with observed indicators
two interacting nodes, fixing loading coefficients and residual
variances for model identification. Edge weights correspond to the sign
(-1 if z<-2, +1 if z>2, 0 otherwise) and P-value of the z-test = w/SE(w)
of the group effect on the LV. Not available if \code{group == NULL}.
}}

\item{limit}{An integer value corresponding to the number of graph 
edges. Beyond this limit, multicore computation is enabled to reduce 
the computational burden. 
By default, \code{limit = 10000}.}

\item{...}{Currently ignored.}
}
\value{
A weighted graph, as an igraph object.
}
\description{
Add data-driven edge and node weights to the input graph.
}
\examples{

# Graph weighting
G <- weightGraph(graph = sachs$graph,
                 data = log(sachs$pkc),
                 group = sachs$group,
                 method = "r2z")

# New edge attributes
head(E(G)$pv); summary(E(G)$pv)
head(E(G)$zsign); table(E(G)$zsign)

# New nodes attributes
head(V(G)$pv); summary(V(G)$pv)
head(V(G)$zsign); table(V(G)$zsign)

}
\references{
Grassi M, Palluzzi F, Tarantino B (2022). SEMgraph: An R Package for Causal Network
Analysis of High-Throughput Data with Structural Equation Models.
Bioinformatics, 2022;, btac567, https://doi.org/10.1093/bioinformatics/btac567

Fisher RA (1915). Frequency Distribution of the Values of the Correlation
Coefficient in Samples from an Indefinitely Large Population. Biometrika,
10(4), 507–521. <doi:10.2307/2331838>
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
